<?php

/*
 * @package     RadicalMart LastView Module
 * @version     __DEPLOY_VERSION__
 * @author      CaveDesign Studio - cavedesign.ru
 * @copyright   Copyright (c) 2009 - 2024 CaveDesign Studio. All Rights Reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://cavedesign.ru/
 */
namespace Joomla\Module\RadicalMartLastview\Site\Dispatcher;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Extension\ModuleInterface;
use Joomla\CMS\Factory;
use Joomla\Input\Input;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;
use Joomla\Module\RadicalMartLastview\Site\Helper\ItemsHelper;

/**
 * Dispatcher class
 *
 * @since  1.0.0
 */
class Dispatcher extends AbstractModuleDispatcher
{
	use HelperFactoryAwareTrait;

	/**
	 * The module extension. Used to fetch the module helper.
	 *
	 * @var   ModuleInterface|null
	 * @since 1.0.0
	 */
	private $moduleExtension;

	public function __construct(\stdClass $module, CMSApplicationInterface $app, Input $input)
	{
		parent::__construct($module, $app, $input);

		$this->moduleExtension = $this->app->bootModule('mod_radicalmart_lastview', 'site');
	}

	/**
	 * Returns the layout data.
	 *
	 * @return  array
	 *
	 * @since   1.0.0
	 */
	protected function getLayoutData()
	{
		$data                    = parent::getLayoutData();
		$data['items']           = (new ItemsHelper($data['params']))->getItems();
		$data['mode']            = ComponentHelper::getParams('com_radicalmart')->get('mode', 'shop');
		$data['moduleclass_sfx'] = htmlspecialchars($data['params']->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');

		// Load language
		Factory::getApplication()->getLanguage()->load('com_radicalmart');

		return $data;
	}
}