<?php
/*
 * @package     RadicalMart LastView Plugin
 * @version     __DEPLOY_VERSION__
 * @author      CaveDesign Studio - cavedesign.ru
 * @copyright   Copyright (c) 2009 - 2024 CaveDesign Studio. All Rights Reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://cavedesign.ru/
 */

namespace Joomla\Plugin\Radicalmart\Lastview\Extension;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\DatabaseDriver;
use Joomla\Event\SubscriberInterface;
use Joomla\Input\Cookie;

class Lastview extends CMSPlugin implements SubscriberInterface
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    bool
	 *
	 * @since  __DEPLOY_VERSION__
	 */
	protected $autoloadLanguage = true;

	/**
	 * Loads the application object.
	 *
	 * @var  CMSApplication
	 *
	 * @since  __DEPLOY_VERSION__
	 */
	protected $app = null;

	/**
	 * Loads the database object.
	 *
	 * @var  DatabaseDriver
	 *
	 * @since  __DEPLOY_VERSION__
	 */
	protected $db = null;

	/**
	 * Plugins forms path.
	 *
	 * @var    string
	 *
	 * @since  __DEPLOY_VERSION__
	 */
	protected string $formsPath = JPATH_PLUGINS . '/system/lastview/forms';


	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since   __DEPLOY_VERSION__
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepare' => 'onContentPrepare',
		];
	}

	/**
	 * Add viewed products to cookies
	 *
	 * @throws \Exception
	 *
	 * @since  __DEPLOY_VERSION__
	 */
	public function onContentPrepare()
	{
		if (!$this->app->isClient('site'))
		{
			return;
		}

		$option  = $this->app->input->getCmd('option');
		$view    = $this->app->input->getCmd('view');
		$item_id = $this->app->input->getCmd('id');

		if ($option === 'com_radicalmart' && $view === 'product')
		{
			$cookie = new Cookie();
			$value = $cookie->getString('last_products_views', '');
			$value = json_decode($value, true);
			if (!empty($value) && !in_array($item_id, $value, true))
			{
				$value[] = $item_id;
				if (count($value) > 12) array_shift($value);
				$cookie->set('last_products_views', json_encode($value), [
					'path'     => '/',
				]);
			}
			elseif (empty($value))
			{
				$cookie->set('last_products_views', json_encode(array($item_id)), [
						'path'     => '/',
				 ]);
			}
		}
	}

}