<?php
/*
 * @package     RadicalMart LastView Module
 * @version     __DEPLOY_VERSION__
 * @author      CaveDesign Studio - cavedesign.ru
 * @copyright   Copyright (c) 2009 - 2024 CaveDesign Studio. All Rights Reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://cavedesign.ru/
 */

namespace Joomla\Module\RadicalMartLastview\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\Input\Input;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Joomla\Input\Cookie;

class ItemsHelper
{
	/**
	 * @var Registry
	 *
	 * @since 1.0.0
	 */
	protected $params;

	/**
	 * @var Input
	 *
	 * @since 1.0.0
	 */
	protected $input;

	/**
	 * @param   Registry  $params
	 *
	 * @since 1.2.0
	 */
	public function __construct(Registry $params)
	{
		$this->params = $params;
		$this->input  = Factory::getApplication()->input;
	}

	/**
	 * Get items
	 *
	 * @since 1.2.0
	 */
	public function getItems()
	{
		// Get items
		$items = $this->getProducts();

		return $items;
	}

	/**
	 * Get products
	 *
	 * @since 1.2.0
	 */
	public function getProducts($limit = 0)
	{
		$app = Factory::getApplication();
		if (!$model = $app->bootComponent('com_radicalmart')->getMVCFactory()->createModel('Products', 'Site', ['ignore_request' => true]))
		{
			throw new \Exception(Text::_('MOD_RADICALMART_LASTVIEW_ERROR_MODEL_NOT_FOUND'), 500);
		}

		$cookie   = new Cookie();
		$lastview = json_decode($cookie->getString('last_products_views', ''), true);
		if (!empty($lastview)) {
			$lastview = (count($lastview) > 1) ? array_slice(array_reverse($lastview),0, (int) $this->params->get('limit', 12)) :
				$lastview;
			$model->setState('filter.item_id', $lastview);
			$model->setState('filter.published', 1);
			$model->setState('filter.language', Multilanguage::isEnabled());

			$items = $model->getItems();

			$sortOrderMap = array_flip($lastview);
			usort($items, function ($a, $b) use ($sortOrderMap) {
				$positionA = isset($sortOrderMap[$a->id]) ? $sortOrderMap[$a->id] : PHP_INT_MAX;
				$positionB = isset($sortOrderMap[$b->id]) ? $sortOrderMap[$b->id] : PHP_INT_MAX;

				return $positionA - $positionB;
			});

			return $items;

		}
	}

}