/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

CREATE TABLE IF NOT EXISTS `#__radicalreviews_reviews`
(
    `id`          int(11)      NOT NULL AUTO_INCREMENT,
    `item_id`     int(11)      NOT NULL DEFAULT 0,
    `context`     varchar(255) NOT NULL DEFAULT '',
    `text`        text         NOT NULL,
    `rating`      tinyint(3)   NOT NULL DEFAULT 0,
    `name`        varchar(255) NOT NULL DEFAULT '',
    `email`       varchar(100) NOT NULL DEFAULT '',
    `source`      json         NULL,
    `state`       tinyint(3)   NOT NULL DEFAULT 0,
    `created`     datetime     NOT NULL DEFAULT '0000-00-00 00:00:00',
    `created_by`  int(11)      NOT NULL DEFAULT 0,
    `modified`    datetime     NOT NULL DEFAULT '0000-00-00 00:00:00',
    `modified_by` int(11)      NOT NULL DEFAULT 0,
    `plugins`     json         NULL,
    PRIMARY KEY `id` (`id`),
    KEY `idx_context` (`context`),
    KEY `idx_item` (`item_id`),
    KEY `idx_state` (`state`),
    KEY `idx_created` (`created`)
)
    ENGINE = InnoDB
    DEFAULT charSET = utf8mb4
    DEFAULT COLLATE = utf8mb4_unicode_ci
    AUTO_INCREMENT = 0;

CREATE TABLE IF NOT EXISTS `#__radicalreviews_rating`
(
    `id`         int(11)  NOT NULL AUTO_INCREMENT,
    `item_id`    int(11)  NOT NULL DEFAULT 0,
    `context`    varchar(255) NOT NULL DEFAULT '',
    `stars`      int(11)  NOT NULL DEFAULT 0,
    `votes`      int(11)  NOT NULL DEFAULT 0,
    `modified`   datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY `id` (`id`),
    KEY `idx_context` (`context`),
    KEY `idx_item` (`item_id`),
    KEY `idx_stars` (`stars`),
    KEY `idx_votes` (`votes`),
    KEY `idx_modified` (`modified`)
)
    ENGINE = InnoDB
    DEFAULT charSET = utf8mb4
    DEFAULT COLLATE = utf8mb4_unicode_ci
    AUTO_INCREMENT = 0;