<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;

class SourceField extends FormField
{
	/**
	 * The form field type.
	 *
	 * @var  string
	 *
	 * @since  2.4.0
	 */
	protected $type = 'timeout';

	/**
	 * Method to attach a JForm object to the field.
	 *
	 * @param   \SimpleXMLElement  $element  The SimpleXMLElement object representing the `<field>` tag for the form
	 *                                       field object.
	 * @param   mixed              $value    The form field value to validate.
	 * @param   string             $group    The field name group control value. This acts as an array container for the
	 *                                       field.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since  2.4.0
	 */
	public function setup(\SimpleXMLElement $element, $value, $group = null)
	{
		if ($return = parent::setup($element, $value, $group))
		{
			if (!empty($this->value) && is_string($this->value))
			{
				$this->value = (new Registry($this->value))->toArray();
			}
		}

		return $return;
	}

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since  2.4.0
	 */
	public function getInput()
	{
		$html      = [];
		$name      = (is_array($this->value) && !empty($this->value['name'])) ? $this->value['name'] : '';
		$nameInput = '<input type="text" placeholder="' . Text::_('COM_RADICALREVIEWS_REVIEW_SOURCE_NAME_LABEL') . '" name="' . $this->name . '[name]" class="form-control w-100" value="' . $name . '">';

		$link      = (is_array($this->value) && !empty($this->value['link'])) ? $this->value['link'] : '';
		$linkInput = '<input type="text" placeholder="' . Text::_('COM_RADICALREVIEWS_REVIEW_SOURCE_LINK_LABEL') . '" name="' . $this->name . '[link]" class="form-control w-100" value="' . $link . '">';

		$html[] = '<div class="row">';
		$html[] = '<div class="col-md-6">';
		$html[] = $nameInput;
		$html[] = '</div>';
		$html[] = '<div class="col-md-6">';
		$html[] = $linkInput;
		$html[] = '</div>';
		$html[] = '</div>';

		return implode("\n", $html);
	}
}