/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!******************************************!*\
  !*** ./com_radicalreviews/es6/stars.es6 ***!
  \******************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('[radicalreviews-rating="container"]').forEach(function (container) {
    var local = 'rating_vote_' + container.getAttribute("data-context") + '_' + container.getAttribute('data-item_id');
    var voted = parseInt(container.getAttribute('data-voted'));
    if (!voted) {
      container.querySelectorAll('[radicalreviews-rating="star"]').forEach(function (star) {
        star.addEventListener('click', function (event) {
          event.preventDefault();
          if (!localStorage.getItem(local)) {
            setChecked(star.getAttribute('data-value'));
            container.setAttribute('data-value', star.getAttribute('data-value'));
            var request = new XMLHttpRequest(),
              requestUrl = container.getAttribute('data-controller'),
              formData = new FormData();
            formData.set('value', star.getAttribute('data-value'));
            request.open('POST', requestUrl);
            request.send(formData);
            request.onreadystatechange = function () {
              if (this.readyState === 4 && this.status === 200) {
                var response = false;
                try {
                  response = JSON.parse(this.response);
                } catch (e) {
                  response = false;
                  console.error(e.message);
                  return;
                }
                if (response.success) {
                  var data = response.data[0];
                  localStorage.setItem(local, star.getAttribute('data-value'));
                  container.setAttribute('data-active', false);
                  UIkit.modal(container.querySelector('[radicalreviews-rating="modal"]'), {
                    container: false
                  }).show();
                } else {
                  console.error(response.message);
                }
              } else if (this.readyState === 4 && this.status !== 200) {
                console.error(request.status + ' ' + request.message);
              }
            };
          }
        });
        star.addEventListener('mouseover', function () {
          setChecked(star.getAttribute('data-value'));
        });
        star.addEventListener('mouseout', function () {
          setChecked(container.getAttribute('data-value'));
        });
      });
    } else {
      setChecked(voted);
      container.setAttribute('data-active', false);
    }
    function setChecked(value) {
      // Remove setting if already rated
      if (container.getAttribute('data-active') !== 'true') {
        return;
      }
      value = parseInt(value);
      container.querySelectorAll('[radicalreviews-rating="star"]').forEach(function (star) {
        if (parseInt(star.getAttribute('data-value')) <= value) {
          star.setAttribute('data-checked', 'true');
        } else {
          star.setAttribute('data-checked', 'false');
        }
      });
    }
  });
  document.querySelectorAll('[radicalreviews-rating="add"]').forEach(function (linkParent) {
    var link = document.createElement('a'),
      linkAttributes = JSON.parse(linkParent.getAttribute('data-link-attributes')),
      voted = parseInt(linkParent.getAttribute('data-reviewed'));
    if (!voted) {
      Object.keys(linkAttributes).forEach(function (key) {
        var value = linkAttributes[key];
        if (key !== 'innerText') {
          link.setAttribute(key, value);
        } else {
          link.innerText = value;
        }
      });
      linkParent.append(link);
    }
  });
});
})();

// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!********************************************!*\
  !*** ./com_radicalreviews/scss/stars.scss ***!
  \********************************************/
// extracted by mini-css-extract-plugin
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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