<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Site\Helper;

\defined('_JEXEC') or die;

use Joomla\CMS\Association\AssociationServiceInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\Database\ParameterType;

abstract class AssociationHelper
{
	/**
	 * Product associations cache.
	 *
	 * @var array|null
	 *
	 * @since 1.0.0
	 */
	protected static ?array $_productAssociations = null;

	/**
	 * Method to get the associations for a given item
	 *
	 * @param   int          $id      Id of the item.
	 * @param   string|null  $view    Name of the view.
	 * @param   string|null  $layout  View layout.
	 *
	 * @return  array   Array of associations for the item.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public static function getAssociations(int $id = 0, string $view = null, string $layout = null): array
	{
		$app        = Factory::getApplication();
		$id         = $id ? $id : $app->input->getInt('id');
		$view       = ($view === null) ? $app->input->get('view') : $view;
		$parsedItem = ReviewsHelper::parseItem($app->input->getString('item'));
		$option     = 'com_' . $parsedItem->component;
		$context    = str_replace('com_', '', $parsedItem->context);
		$item_id    = $parsedItem->item_id;
		$item_view  = $parsedItem->view;

		$result = [];

		// Set associations for review
		// There is no input item than we need ge to database for item_id, component and context
		if ($view === 'review')
		{
			$db      = Factory::getContainer()->get('DatabaseDriver');
			$dbquery = $db->getQuery(true)
				->select(['item_id', 'context'])
				->from('#__radicalreviews_reviews')
				->where($db->quoteName('id') . ' = ' . $db->quote($id));
			$db->setQuery($dbquery);

			$review  = $db->loadObject();
			$item_id = $review->item_id;
			$context = str_replace('com_', '', $review->context);
			list($option, $item_view) = explode('.', $review->context, 2);
		}

		// Get assotiations from component
		$component = $app->bootComponent($option);

		if ($component instanceof AssociationServiceInterface)
		{
			$cassociations = $component->getAssociationsExtension()->getAssociationsForItem($item_id, $item_view);
		}
		else
		{
			// Load component associations
			$class = $parsedItem->component . 'HelperAssociation';
			\JLoader::register($class, JPATH_SITE . '/components/' . $option . '/helpers/association.php');

			if (class_exists($class) && \is_callable(array($class, 'getAssociations')))
			{
				$cassociations = \call_user_func(array($class, 'getAssociations', $item_id, $item_view));
			}
		}

		$languages   = LanguageHelper::getContentLanguages(false, false, null, 'ordering', 'asc');

		foreach ($languages as $language)
		{
			if (isset($cassociations[$language->lang_code]))
			{
				parse_str($cassociations[$language->lang_code], $url);

				if (isset($url['id']))
				{
					$id = (int) explode(':', $url['id'])[0];

					if ($view === 'reviews' || $view === 'review')
					{
						$link = RouteHelper::getReviewsRoute($id, $context, $language->lang_code);
					}
					elseif ($view === 'form')
					{
						$link = RouteHelper::getFormRoute($id, $context, $language->lang_code);
					}

					$result[$language->lang_code] = $link;
				}
			}
		}

		return $result;
	}
}