<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\View\Review;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarFactoryInterface;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Component\RadicalReviews\Administrator\Helper\ReviewsHelper;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;

class HtmlView extends BaseHtmlView
{
	/**
	 * Model state variables.
	 *
	 * @var  CMSObject
	 *
	 * @since  1.0.0
	 */
	protected $state;

	/**
	 * Form object.
	 *
	 * @var  Form
	 *
	 * @since  1.0.0
	 */
	protected $form;

	/**
	 * The active item.
	 *
	 * @var  object
	 *
	 * @since  1.0.0
	 */
	protected $item;

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse.
	 *
	 * @return  mixed  A string if successful, otherwise an Error object.
	 *
	 * @throws  Exception
	 *
	 * @since  1.0.0
	 */
	public function display($tpl = null)
	{
		$this->state = $this->get('State');
		$this->form  = $this->get('Form');
		$this->item  = $this->get('Item');

		// Check for errors
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode('\n', $errors), 500);
		}

		// Load languages
		ReviewsHelper::loadPluginsLanguages();

		// Add title and toolbar
		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add title and toolbar.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	protected function addToolbar()
	{
		$isNew   = ($this->item->id == 0);
		$canDo   = ReviewsHelper::getActions('com_radicalreviews', 'review', $this->item->id);
		$toolbar = Toolbar::getInstance('toolbar');

		// Disable menu
		Factory::getApplication()->input->set('hidemainmenu', true);

		// Set page title
		$title = ($isNew) ? Text::_('COM_RADICALREVIEWS_REVIEW_ADD') : Text::_('COM_RADICALREVIEWS_REVIEW_EDIT');
		ToolbarHelper::title(Text::_('COM_RADICALREVIEWS') . ': ' . $title, 'comment');

		// Add apply & save buttons
		if ($canDo->get('core.edit'))
		{
			ToolbarHelper::apply('review.apply');
			ToolbarHelper::save('review.save');
		}

		// Add cancel button
		ToolbarHelper::cancel('review.cancel', 'JTOOLBAR_CLOSE');

		// Add preview button
		if ($this->item->id)
		{
			// Preview button
			if ($this->item->state > 0 && $this->item->object)
			{
				if (Multilanguage::isEnabled())
				{
					$language = $this->item->object->language ?? '';
				}

				$link = Route::link('site', RouteHelper::getReviewRoute($this->item->id, $this->item->item_id, $this->item->context, $language), false);
				$html = '<joomla-toolbar-button class="ms-auto"><a href="' . $link . '" target="_blank" class="btn btn-small btn-primary">' . Text::_('COM_RADICALREVIEWS_REVIEW_PREVIEW') . '</a></joomla-toolbar-button>';

				$toolbar->appendButton('Custom', $html);
			}
		}
	}
}