<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\Component\RadicalReviews\Administrator\Helper\MediaHelper;

$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalreviews');
$assets->usePreset('com_radicalreviews.administrator.field.media');

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string  $autocomplete   Autocomplete attribute for the field.
 * @var   boolean $autofocus      Is autofocus enabled?
 * @var   string  $class          Classes for the input.
 * @var   string  $description    Description of the field.
 * @var   boolean $disabled       Is this field disabled?
 * @var   string  $group          Group the field belongs to. <fields> section in form XML.
 * @var   boolean $hidden         Is this field hidden in the form?
 * @var   string  $hint           Placeholder for the field.
 * @var   string  $id             DOM id of the field.
 * @var   string  $label          Label of the field.
 * @var   string  $labelclass     Classes to apply to the label.
 * @var   boolean $multiple       Does this field support multiple values?
 * @var   string  $name           Name of the input field.
 * @var   string  $onchange       Onchange attribute for the field.
 * @var   string  $onclick        Onclick attribute for the field.
 * @var   string  $pattern        Pattern (Reg Ex) of value of the form field.
 * @var   boolean $readonly       Is this field read only?
 * @var   boolean $repeat         Allows extensions to duplicate elements.
 * @var   boolean $required       Is this field required?
 * @var   integer $size           Size attribute of the input.
 * @var   boolean $spellcheck     Spellcheck state for the form field.
 * @var   string  $validate       Validation rules to apply.
 * @var   array   $value          Value attribute of the field.
 * @var   array   $checkedOptions Options that will be set as checked.
 * @var   boolean $hasValue       Has this field a value assigned?
 * @var   array   $options        Options available for this field.
 * @var   array   $inputType      Options available for this field.
 * @var   string  $accept         File types that are accepted.
 * @var   string  $dataAttribute  Miscellaneous data attributes preprocessed for HTML output
 * @var   array   $dataAttributes Miscellaneous data attribute for eg, data-*.
 * @var   string  $dirname        The directory name
 * @var   string  $addonBefore    The text to use in a bootstrap input group prepend
 * @var   string  $addonAfter     The text to use in a bootstrap input group append
 */

$componentParams = ComponentHelper::getParams('com_radicalreviews');
$limit           = $componentParams->get('media_count', $componentParams->get('images_count', 3));
$count           = $value ? count($value) : 0;

?>
<div radicalreviews-media="container" data-limit="<?php echo $limit; ?>"
     data-readonly="<?php echo $readonly ? 'true' : 'false'; ?>">
    <div class="w-100" radicalreviews-media="error" hidden>
        <div class="alert alert-danger error-text"></div>
    </div>

    <div class="row row-cols-4 g-4" radicalreviews-media="grid">
        <div radicalreviews-media="upload">
            <label for="<?php echo $id . '_upload'; ?>"
                   class="media-block card d-flex justify-content-center flex-wrap card">
                <span class="icon-plus" radicalreviews-media="icon-add"></span>
                <span class="icon-spin fa-spinner" role="status" radicalreviews-media="icon-loading" hidden></span>
                <input id="<?php echo $id . '_upload'; ?>" type="file" accept="image/*, video/*" multiple>
            </label>
        </div>

		<?php if ($value) : ?>
			<?php foreach ($value as $media) :
				?>
                <div radicalreviews-media="file" data-media="true">
                    <div class="media-block card d-flex justify-content-center flex-wrap">
                        <span class="position-absolute top-0 end-0 mt-3 me-3" style="z-index: 1;">
                            <button type="button" radicalreviews-media="delete" class="btn btn-danger btn-sm" data-path="<?php echo $media; ?>">
                                <span class="icon-cancel"></span>
                            </button>
                        </span>
                        <?php
                            echo $this->subLayout(MediaHelper::getInstance()->checkMedia(JPATH_ROOT . '/' . $media), ['media' => $media]);
                        ?>
                    </div>
                </div>
			<?php endforeach; ?>
		<?php endif; ?>

		<?php for ($i = 1; $i <= $limit; $i++): ?>
            <div radicalreviews-media="empty" <?php echo ($i <= $count) ? 'hidden' : ''; ?>>
                <div class="media-block card d-flex justify-content-center flex-wrap"></div>
            </div>
		<?php endfor; ?>

        <div radicalreviews-media="clone" hidden>
            <div radicalreviews-media="file">
                <div class="media-block card d-flex justify-content-center flex-wrap">
				    <span class="position-absolute top-0 end-0 mt-3 me-3" style="z-index: 1;">
                        <button type="button" radicalreviews-media="remove" class="btn btn-danger btn-sm">
                            <span class="icon-cancel"></span>
                        </button>
                    </span>
                    <img class="object-fit-cover w-100" src="#">
                    <video class="object-fit-cover w-100" src="#"></video>
                    <input type="file" data-name="<?php echo $name . '[]'; ?>" accept="image/*, video/*">
                </div>
            </div>
        </div>
    </div>
</div>