<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  Form          $form     Form object.
 * @var  object|string $fieldset Fieldset object.
 *
 */

if (empty($fieldset))
{
	return;
}

if (is_string($fieldset))
{
	foreach ($form->getFieldsets() as $name => $object)
	{
		if ($name === $fieldset)
		{
			$fieldset = $object;
			break;
		}
	}
}
if (!is_object($fieldset))
{
	return;
}

$content = $form->renderFieldset($fieldset->name);

if (!$content)
{
	return;
}

?>

<fieldset class="options-form form-horizontal">
	<?php if (!empty($fieldset->label) || !empty($fieldset->description)): ?>
        <legend>
			<?php if (!empty($fieldset->label)): ?>
                <div><?php echo Text::_($fieldset->label); ?></div>
			<?php endif; ?>
			<?php if (!empty($fieldset->description)): ?>
                <div class="small" style="font-weight: normal"><?php echo Text::_($fieldset->description); ?></div>
			<?php endif; ?>
        </legend>
	<?php endif; ?>
	<?php echo $content; ?>
</fieldset>