<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

use Joomla\CMS\HTML\Helpers\StringHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  object $item Review item object.
 *
 */

?>

<div class="uk-card uk-card-default uk-margin-bottom uk-card-body uk-card-small">
    <div class="uk-child-width-expand@m uk-text-break" uk-grid="">

		<?php if ($item->image): ?>
            <div class="uk-width-medium@s">
                <a href="<?php echo $item->link; ?>"
                   class="uk-display-block uk-cover-container uk-height-1-1"
                   style="min-height: 222px">
					<?php echo HTMLHelper::image($item->image,
						htmlspecialchars($item->object->title), array('uk-cover' => '')); ?>

					<?php if ($item->video) : ?>
                        <div class="uk-overlay-primary uk-position-cover"></div>
                        <div class="uk-overlay uk-position-center uk-light">
                            <i uk-icon="icon: play-circle; ratio: 3;"></i>
                        </div>
					<?php endif; ?>
                </a>
            </div>
		<?php endif; ?>

        <div>
            <div class="uk-flex uk-flex-column uk-flex-between uk-height-1-1">
                <div class="uk-flex uk-flex-column uk-position-relative uk-flex-1"
                     style="flex-grow: 1">
                    <div class="uk-height-max-small uk-overflow-hidden"
                         style="mask-image: linear-gradient(180deg, #000 50%, transparent); -webkit-mask-image: linear-gradient(180deg, #000 50%, transparent);">
						<?php
						$text = '';

						foreach (preg_split('/\r\n|\r|\n/', $item->text) as $line)
						{
							if (trim($line)) $text .= '<p>' . $line . '</p>';
						}

						echo StringHelper::truncate($text, 300, true, true);
						?>
                        <a href="<?php echo $item->link; ?>" class="uk-position-cover"></a>
                    </div>
					<?php if ($item->source && $item->source->get('link') && $item->source->get('name')) : ?>
                        <div class="uk-margin-small-top">
							<?php echo Text::_('COM_RADICALREVIEWS_REVIEW_SOURCE'); ?>
                            <button class="uk-button uk-button-link"
                                    onclick="window.open('<?php echo $item->source->get('link'); ?>', '_blank');"><?php echo $item->source->get('name'); ?></button>
                        </div>
					<?php endif; ?>
                </div>
                <div class="uk-margin-small-top uk-child-width-1-2@s uk-flex-bottom" uk-grid="">
                    <div>
                        <div class="uk-flex uk-flex-middle">
							<?php for ($i = 1; $i <= 5; $i++): ?>
                                <span radicalreviews-rating="star" data-value="<?php echo $i; ?>"
                                      data-checked="<?php echo ($i <= $item->rating) ? 'true' : 'false'; ?>"
                                      data-active="true" class="uk-h2 uk-margin-remove"></span>
							<?php endfor; ?>
                            <span class="uk-margin-remove uk-text-muted">(<?php echo $item->rating; ?>)</span>
                        </div>
                    </div>
                    <div class="uk-text-meta uk-text-right@s">
                        <div><?php echo $item->author_name; ?></div>
                        <div>
							<?php echo HTMLHelper::date($item->created, Text::_('DATE_FORMAT_LC3')); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>