/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
/*!*****************************************!*\
  !*** ./com_radicalreviews/es6/form.es6 ***!
  \*****************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var RadicalReviewsForm = /*#__PURE__*/function () {
  function RadicalReviewsForm() {
    _classCallCheck(this, RadicalReviewsForm);
    this.options = null;
    this.controller = null;
    this.form = null;
    this.container = null;
    this.csrf = null;
    this.stepLast = 1;
  }
  _createClass(RadicalReviewsForm, [{
    key: "initialization",
    value: function initialization() {
      // Set form
      var form = document.querySelector('[radicalreviews="form"], [data-radicalreviews="form"]');
      if (form) {
        this.setVariable('form', form);
        this.setVariable('controller', form.getAttribute('action'));
        var useragentInput = form.querySelector('input[name="jform[useragent]"]');
        if (useragentInput) {
          useragentInput.value = window.navigator.userAgent;
        }
      }

      // Set container
      var container = document.querySelector('[radicalreviews="container"], [data-radicalreviews="container"]');
      if (container) {
        this.setVariable('container', container);
      }

      // Set step
      var stepLast = 1;
      form.querySelectorAll('[data-step]').forEach(function (element) {
        var step = parseInt(element.getAttribute('data-step'));
        if (step > stepLast) {
          stepLast = step;
        }
      });
      this.setVariable('stepLast', stepLast);
    }
  }, {
    key: "setVariable",
    value: function setVariable(key, value) {
      this[key] = value;
    }
  }, {
    key: "getVariable",
    value: function getVariable(key) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return !this[key] || this[key] === null ? defaultValue : this[key];
    }
  }, {
    key: "back",
    value: function back(link) {
      if (this.form) {
        var stepCurrent = parseInt(this.form.getAttribute('data-current'));
        if (stepCurrent === 1) {
          window.location.href = link.getAttribute('data-link');
        } else {
          this.setStep(stepCurrent - 1);
        }
      }
    }
  }, {
    key: "submit",
    value: function submit() {
      var _this = this;
      if (this.form) {
        var stepCurrent = parseInt(this.form.getAttribute('data-current')),
          stepNext = stepCurrent + 1,
          stepBlock = this.form.querySelector('[data-step="' + stepCurrent + '"]'),
          errorMessages = this.form.querySelector('#errorMessages'),
          submitButton = this.form.querySelector('#submitButton'),
          error = [];
        errorMessages.innerHTML = '';
        errorMessages.style.display = 'none';
        stepBlock.querySelectorAll('input:not([type="file"]), select, textarea').forEach(function (input) {
          if (input.value === '' || input.value === '0') {
            input.classList.add('uk-form-danger');
            error.push(Joomla.Text._('COM_RADICALREVIEWS_ERROR_EMPTY_DATA') + ': ' + input.getAttribute('placeholder'));
          } else {
            input.classList.remove('uk-form-danger');
          }
        });
        if (error.length > 0) {
          errorMessages.innerHTML = error.join('<br>');
          errorMessages.style.display = '';
        } else {
          if (stepCurrent === this.stepLast && document.formvalidator.isValid(this.form)) {
            this.triggerEvent('onRadicalReviewsAddReview');
            var loading = document.querySelector('[radicalreviews="loading"], [data-radicalreviews="loading"]');
            if (loading) {
              loading.style.display = '';
            }
            this.sendAjax('review.addReview', new FormData(this.form)).then(function (result) {
              _this.triggerEvent('onRadicalReviewsAddReviewSuccess', result);
              submitButton.style.display = 'none';

              // Remove Joomla messages
              Joomla.removeMessages();

              // Check redirect
              if (result.redirect) {
                window.location.href = result.redirect;
              } else {
                // Remove loading
                loading.style.display = 'none';

                // Add Joomla success message
                Joomla.renderMessages({
                  'message': [result.message]
                });
                _this.renderLayout(result.html);
              }
            }).catch(function (error) {
              if (loading) {
                loading.style.display = 'none';
              }
              _this.triggerEvent('onRadicalReviewAddReviewError', error.message);
              console.error(error.message);

              // Remove Joomla messages
              Joomla.removeMessages();

              // Add Joomla error message
              Joomla.renderMessages({
                'error': [error.message]
              });
            });
          } else if (stepCurrent !== this.stepLast) {
            this.setStep(stepNext);
          }
        }
      }
    }
  }, {
    key: "setStep",
    value: function setStep(step) {
      if (this.form) {
        this.form.querySelectorAll('[data-step]').forEach(function (block) {
          if (parseInt(block.getAttribute('data-step')) === step) {
            block.style.display = '';
          } else {
            block.style.display = 'none';
          }
        });
        this.form.setAttribute('data-current', step);
      }
    }
  }, {
    key: "triggerEvent",
    value: function triggerEvent() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      if (name) {
        console.debug('RadicalReviews Triggered:' + name);
        document.dispatchEvent(new CustomEvent(name, {
          detail: data
        }));
      }
    }
  }, {
    key: "sendAjax",
    value: function sendAjax() {
      var _this2 = this;
      var task = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var csrfCache = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return new Promise(function (success, error) {
        if (task === null) {
          return error({
            message: 'Task is empty'
          });
        }
        var controller = _this2.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var isFormData = data instanceof FormData,
          formData = isFormData ? data : new FormData();
        if (!isFormData) {
          formData = _this2.objectToFormData(data, formData);
        }
        formData.set('task', task);
        var csrf = _this2.getVariable('csrf', false);
        if (!csrfCache || !csrf) {
          _this2.getCSRF().then(function (csrf) {
            formData.set(csrf, '1');
            _this2.sendRequest(controller, formData).then(function (s) {
              return success(s);
            }).catch(function (e) {
              return error(e);
            });
          }).catch(function (e) {
            if (e.message === 'Request aborted' || e.message === null || e.message === '') {
              console.error('aborted');
            } else {
              return error(e);
            }
          });
        } else {
          formData.set(csrf, '1');
          _this2.sendRequest(controller, formData).then(function (s) {
            return success(s);
          }).catch(function (e) {
            return error(e);
          });
        }
      });
    }
  }, {
    key: "objectToFormData",
    value: function objectToFormData() {
      var _this3 = this;
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      if (formData === null) {
        formData = new FormData();
      }
      if (path === null) {
        path = '';
      }
      Object.keys(data).forEach(function (key) {
        var name = path ? path + '[' + key + ']' : key,
          value = data[key];
        if (Array.isArray(value)) {
          value.forEach(function (val) {
            formData.append(name + '[]', val);
          });
        } else if (_typeof(value) === 'object') {
          formData = _this3.objectToFormData(value, formData, name);
        } else {
          formData.set(name, value);
        }
      });
      return formData;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(controller, formData) {
      return new Promise(function (success, error) {
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                return success(response.data);
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            return error(e);
          }
        });
      });
    }
  }, {
    key: "getCSRF",
    value: function getCSRF() {
      var _this4 = this;
      return new Promise(function (success, error) {
        var controller = _this4.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var formData = new FormData();
        formData.set('task', 'getCSRF');
        formData.set('check_post', '1');
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                var token = response.data;
                if (token) {
                  success(token);
                  _this4.setVariable('csrf', token);
                } else {
                  return error({
                    message: 'Token not found'
                  });
                }
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            if (e.message === 'Request aborted' || e.message === null || e.message === '') {
              console.error('aborted');
            } else {
              return error(e);
            }
          }
        });
      });
    }
  }, {
    key: "renderLayout",
    value: function renderLayout(html) {
      if (this.container) {
        this.container.innerHTML = html;
      }
    }
  }]);
  return RadicalReviewsForm;
}();
window.RadicalReviewsFormClass = null;
window.RadicalReviewsForm = function () {
  if (window.RadicalReviewsFormClass === null) window.RadicalReviewsFormClass = new RadicalReviewsForm();
  return window.RadicalReviewsFormClass;
};
document.addEventListener('DOMContentLoaded', function () {
  window.RadicalReviewsForm().initialization();
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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