<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Site\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Helper\RouteHelper as RouteHelperCore;
use Joomla\CMS\Language\Multilanguage;

class RouteHelper extends RouteHelperCore
{
	/**
	 * Fetches add rating route.
	 *
	 * @param   int     $item_id   The id of the item.
	 * @param   string  $context   The name of the context.
	 * @param   string  $format
	 * @param   string  $language  The language.
	 *
	 * @return  string  Add rating link.
	 *
	 * @since  1.0.0
	 */
	public static function getAddRating($item_id = null, $context = null, $format = 'json', $language = null)
	{
		$itemId = self::getItemid();

		$link = 'index.php?option=com_ajax&plugin=radicalreviews&group=system&action=addRating';
		$link .= '&item_id=' . $item_id;
		$link .= '&context=' . $context;
		$link .= '&format=' . $format;
		$link .= '&Itemid=' . $itemId;

		if ($language && $language !== '*' && Multilanguage::isEnabled())
		{
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Fetches form route.
	 *
	 * @param   int     $item_id   The id of the item.
	 * @param   int     $context   The name of the context.
	 * @param   string  $language  The language.
	 *
	 * @return  string  Form view link.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public static function getFormRoute($item_id = null, $context = null, $language = null)
	{
		$context = self::clear($context);
		$slug    = $context . ':' . $item_id;
		$itemId  = self::getItemid();

		$link = 'index.php?option=com_radicalreviews&view=form';
		$link .= '&item=' . $slug;
		$link .= '&Itemid=' . $itemId;

		if ($language && $language !== '*' && Multilanguage::isEnabled())
		{
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Fetches reviews route.
	 *
	 * @param   int     $id        The id of the item.
	 * @param   int     $context   The name of the context.
	 * @param   string  $language  The language.
	 *
	 * @return  string  Reviews view link.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public static function getReviewsRoute($item_id = null, $context = null, $language = null)
	{
		$context = self::clear($context);
		$slug    = $context . ':' . $item_id;
		$itemId  = self::getItemid();

		$link = 'index.php?option=com_radicalreviews&view=reviews';
		$link .= '&item=' . $slug;
		$link .= '&Itemid=' . $itemId;

		if ($language && $language !== '*' && Multilanguage::isEnabled())
		{
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Fetches reviews route.
	 *
	 * @param   int     $id        The id of the review.
	 * @param   int     $item_id   The id of the item.
	 * @param   int     $context   The name of context.
	 * @param   string  $language  The language.
	 *
	 * @return  string  Review view link.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public static function getReviewRoute($id = null, $item_id = null, $context = null, $language = null)
	{
		$context = self::clear($context);
		$slug    = $context . ':' . $item_id;
		$itemId  = self::getItemid();

		$link = 'index.php?option=com_radicalreviews&view=review';
		$link .= '&id=' . $id;
		$link .= '&item=' . $slug;
		$link .= '&Itemid=' . $itemId;

		if ($language && $language !== '*' && Multilanguage::isEnabled())
		{
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Method for get item id for route
	 *
	 * @return  int  Menu Itemid.
	 *
	 * @since  1.0.0
	 */
	public static function getItemid()
	{
		$contextParams = ComponentHelper::getParams('com_radicalreviews');

		return (int) $contextParams->get('reviews_itemid', 0);
	}

	/**
	 * Method for clearing context.
	 *
	 * @param   string  $context  Context
	 *
	 * @return  string  Context.
	 *
	 * @since  1.0.0
	 */
	public static function clear($context)
	{
		return str_replace(['com_', '.'], ['', '-'], $context);
	}
}