<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalReviews\Site\Helper\ReviewsHelper;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;

$this->document->getWebAssetManager()->usePreset('com_radicalreviews.site.form');

// Set uikit classes to form
$hasUserFields  = array();
$needUserFields = ComponentHelper::getParams('com_radicalreviews')->get('required_user_data', 1);

foreach ($this->form->getFieldsets() as $key => $fieldset)
{
	foreach ($this->form->getFieldset($key) as $field)
	{
		$name  = $field->fieldname;
		$group = $field->group;
		$type  = strtolower($field->type);
		$class = $this->form->getFieldAttribute($name, 'class', '', $group);
		$input = $field->input;

		if ($type === 'text')
		{
			$class .= ' uk-input';
		}
		if ($type === 'list' || preg_match('#<select#', $input))
		{
			$class .= ' uk-select';
		}
        elseif ($type === 'textarea' || preg_match('#<textarea#', $input))
		{
			$class .= ' uk-textarea';
		}
        elseif ($type === 'range')
		{
			$class .= ' uk-range';
		}

		$this->form->setFieldAttribute($name, 'class', $class, $group);

        if (in_array($name, array('name', 'phone', 'email'))) {
            $hasUserFields[$name] = true;
        }
	}
}

?>

<div id="radicalreviews" class="form">
    <h1><?php echo Text::sprintf('COM_RADICALREVIEWS_REVIEW_TITLE', $this->object->title); ?></h1>

    <div radicalreviews="loading"
         class="uk-position-fixed uk-position-cover uk-overlay-default uk-flex uk-position-z-index uk-flex-center uk-flex-middle"
         style="display: none">
        <div uk-spinner="ratio: 3"></div>
    </div>

    <div class="uk-child-width-expand" uk-grid="">
        <div class="uk-width-1-3@m uk-flex-last@m">
            <div class="uk-margin">
				<?php
				echo LayoutHelper::render('plugins.radicalreviews.' . ReviewsHelper::clearContext($this->object->context) . '.default', ['item' => $this->object]);
				?>
            </div>
        </div>
        <div>
            <div radicalreviews="container">
                <form action="<?php echo Route::_(RouteHelper::getFormRoute($this->object->id, $this->object->context)); ?>"
                      method="post" name="adminForm" id="reviewForm" class="uk-form form-validate"
                      enctype="multipart/form-data" data-current="1"
                      radicalreviews="form">
                    <div id="errorMessages" class="uk-alert uk-alert-danger uk-margin" style="display: none"></div>
                    <div data-step="1">
                        <div class="uk-margin uk-form-horizontal">
                            <div class="uk-form-label"><?php echo Text::_('COM_RADICALREVIEWS_REVIEW_RATING'); ?></div>
                            <div class="uk-form-controls"><?php echo $this->form->getInput('rating'); ?></div>
                        </div>
                        <div class="uk-margin uk-form-horizontal">
                            <div class="uk-form-label"><?php echo Text::_('COM_RADICALREVIEWS_REVIEW_MEDIA'); ?></div>
                            <div class="uk-form-controls"><?php echo $this->form->getInput('media'); ?></div>
                        </div>
                        <div class="uk-margin"><?php echo $this->form->getInput('text'); ?></div>
                    </div>
					<?php if ($hasUserFields && $needUserFields): ?>
                        <div data-step="2" style="display:none;">
                            <div class="uk-child-width-1-2@s" uk-grid="">
								<?php foreach ($hasUserFields as $fieldname => $has): ?>
                                    <div>
                                        <div><?php echo $this->form->getInput($fieldname); ?></div>
                                        <div class="uk-text-muted uk-text-small uk-margin-small-top">
                                            * <?php echo Text::_('COM_RADICALREVIEWS_REVIEW_' . $fieldname . '_DESCRIPTION'); ?>
                                        </div>
                                    </div>
								<?php endforeach; ?>
                            </div>
                        </div>
					<?php endif; ?>

                    <div class="uk-margin">
                        <a id="prevButton" onclick="window.RadicalReviewsForm().back(this)"
                           data-link="<?php echo Route::_(RouteHelper::getReviewsRoute($this->object->id, $this->object->context), false); ?>"
                           class="uk-button uk-button-default uk-margin-right">
							<?php echo Text::_('COM_RADICALREVIEWS_REVIEW_BACK'); ?>
                        </a>
                        <a id="submitButton" onclick="window.RadicalReviewsForm().submit()"
                           class="uk-button uk-button-primary">
							<?php echo Text::_('COM_RADICALREVIEWS_REVIEW_BUTTON'); ?>
                        </a>
                    </div>
					<?php echo $this->form->renderFieldSet('hidden'); ?>
                    <input type="hidden" name="task" value=""/>
                </form>
            </div>
        </div>
    </div>
</div>