<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Component\RadicalReviews\Site\Helper\ReviewsHelper;

$this->document->getWebAssetManager()->useStyle('com_radicalreviews.site.stars');

?>
<div id="radicalreviews" class="review">
    <h1><?php echo Text::sprintf('COM_RADICALREVIEWS_REVIEW_FULL_TITLE', $this->object->title, $this->item->id); ?></h1>

    <?php if (!$this->reviewed) : ?>
        <div class="uk-margin">
            <a href="<?php echo $this->object->addReview; ?>" class="uk-button uk-button-primary">
                <?php echo Text::_('COM_RADICALREVIEWS_REVIEWS_ADD'); ?>
            </a>
        </div>
    <?php endif; ?>

    <div class="uk-child-width-expand" uk-grid="">
        <div class="uk-width-1-3@m uk-flex-last@m">
            <div class="uk-margin">
				<?php
				echo LayoutHelper::render('plugins.radicalreviews.' .ReviewsHelper::clearContext($this->object->context) . '.default', ['item' => $this->object]);
				?>
            </div>
        </div>
        <div>
			<?php
			echo LayoutHelper::render('components.radicalreviews.review.review', ['item' => $this->item]);
			?>
        </div>
    </div>