<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Plugin\RadicalReviews\Email\Extension;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Component\RadicalReviews\Administrator\Traits\PluginTrait;
use Joomla\Component\RadicalReviews\Site\Helper\ReviewsHelper;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\Plugin\RadicalReviews\Content\Helper\ContentHelper;
use Joomla\Registry\Registry;

class Email extends CMSPlugin implements SubscriberInterface
{
	use PluginTrait;

	/**
	 * Load the language file on instantiation.
	 *
	 * @var    bool
	 *
	 * @since  1.1.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * Loads the application object.
	 *
	 * @var  \Joomla\CMS\Application\CMSApplication
	 *
	 * @since  1.1.0
	 */
	protected $app = null;

	/**
	 * Loads the database object.
	 *
	 * @var  \Joomla\Database\DatabaseDriver
	 *
	 * @since  1.1.0
	 */
	protected $db = null;

	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since   1.1.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onRadicalReviewsConfigForm' => 'onRadicalReviewsConfigForm',
			'onRadicalReviewsAfterSave'  => 'onRadicalReviewsAfterSave'
		];
	}

	/**
	 * Constructor.
	 *
	 * @param   DispatcherInterface  &$subject  The object to observe.
	 * @param   array                 $config   An optional associative array of configuration settings.
	 *
	 * @since  1.1.0
	 */
	public function __construct(&$subject, $config = [])
	{
		$this->componentParams = ComponentHelper::getParams('com_radicalreviews');

		parent::__construct($subject, $config);
	}

	/**
	 * Method to change forms.
	 *
	 * @param   Event  $event  The event.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.1.0
	 */
	public function onRadicalReviewsAfterSave(Event $event)
	{
		if (!$this->componentParams->get('email_enable', 0))
		{
			return;
		}

		$data   = $event->getArgument('data');
		$review = $event->getArgument('review');

		$this->sendMail($review, $data);
	}

	/**
	 * Method to send mail with review to list of recipients.
	 *
	 * @param   object  $review  Review object.
	 * @param   array   $data    Array of extra data.
	 *
	 * @since  1.0.0
	 */
	protected function sendMail($review, $data = [])
	{
		if (empty($review)) return;

		Factory::getApplication()->getLanguage()->load('plg_radicalreviews_email', JPATH_ADMINISTRATOR);

		// Get Sender
		$app    = Factory::getApplication();
		$sender = array($app->get('mailfrom'), $app->get('sitename'));
		$emails = $this->componentParams->get('email_recipients');
		$emails = !empty($emails) ? array_map('trim', explode(',', $emails)) : $app->get('mailfrom');

		// Get body
		$displayData = array(
			'header' => '',
			'item'   => $review,
			'footer' => [
				'ip'        => $data['ip'] ?? '',
				'useragent' => $data['useragent'] ?? '',
			],
		);

		$body = LayoutHelper::render('plugins.radicalreviews.email.default', $displayData);

		// Send mail
		$mail = Factory::getMailer();
		$mail->setSubject(Text::sprintf('PLG_RADICALREVIEWS_EMAIL_SUBJECT', $app->get('sitename')));
		$mail->setSender($sender);
		$mail->addRecipient($emails);
		$mail->setBody($body);
		$mail->isHtml(true);
		$mail->Encoding = 'base64';

		try
		{
			$mail->send();
		}
		catch (\Exception $e)
		{

		}
	}
}