<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Traits;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Session\Session;
use Joomla\Input\Input;
use Joomla\Input\Json;

trait JsonControllerTrait
{
	/**
	 * Response code.
	 *
	 * @var  int|null
	 *
	 * @since  1.0.0
	 */
	protected ?int $code = null;

	/**
	 * Constructor.
	 *
	 * @param   array                      $config       An optional associative array of configuration settings.
	 *                                                   Recognized key values include 'name', 'default_task', 'model_path', and
	 *                                                   'view_path' (this list is not meant to be comprehensive).
	 * @param   MVCFactoryInterface|null   $factory      The factory.
	 * @param   CMSApplication|null        $app          The Application for the dispatcher
	 * @param   Input|null                 $input        Input
	 * @param   FormFactoryInterface|null  $formFactory  The form factory.
	 *
	 * @throws \Exception
	 *
	 * @since   1.0.0
	 */
	public function __construct(
		$config = [],
		MVCFactoryInterface $factory = null,
		?CMSApplication $app = null,
		?Input $input = null,
		FormFactoryInterface $formFactory = null
	)
	{
		// Add json input
		$app = Factory::getApplication();
		if ($data = new Json())
		{
			foreach ($data->getArray() as $name => $value)
			{
				$app->input->def($name, $value);
			}
		}

		parent::__construct($config, $factory, $app, $input);
	}

	/**
	 * Method to set json response.
	 *
	 * @param   mixed  $response  Response data.
	 *
	 * @throws  \Exception
	 *
	 * @return  bool True on success, False on failure.
	 *
	 * @since  1.0.0
	 */
	protected function setJsonResponse($response = null): bool
	{
		$message = (is_array($this->message)) ? implode(PHP_EOL, $this->message) : $this->message;
		$code    = (!empty($this->code)) ? $this->code : 200;

		header('Content-Type: application/json');
		echo new JsonResponse($response, $message, ($code !== 200));
		Factory::getApplication()->close($code);

		return ($code === 200);
	}

	/**
	 * Method to check ajax token and close app in failure.
	 *
	 * @throws \Exception
	 *
	 * @since 1.0.0
	 */
	protected function checkAjaxToken()
	{
		// Check token
		if (!Session::checkToken('POST'))
		{
			$this->message = Text::_('JINVALID_TOKEN_NOTICE');
			$this->code    = 401;

			$this->setJsonResponse();
		}
	}
}