<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\View\Reviews;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Pagination\Pagination;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarFactoryInterface;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\Component\RadicalReviews\Administrator\Helper\ReviewsHelper;

class HtmlView extends BaseHtmlView
{
	/**
	 * Model state variables.
	 *
	 * @var  \Joomla\CMS\Object\CMSObject
	 *
	 * @since  1.0.0
	 */
	protected $state;

	/**
	 * Products array.
	 *
	 * @var  array
	 *
	 * @since  1.0.0
	 */
	protected $items;

	/**
	 * Pagination object.
	 *
	 * @var  Pagination
	 *
	 * @since  1.0.0
	 */
	protected $pagination;

	/**
	 * Form object for search filters.
	 *
	 * @var  Form
	 *
	 * @since  1.0.0
	 */
	public $filterForm;

	/**
	 * The active search filters.
	 *
	 * @var  array
	 *
	 * @since  1.0.0
	 */
	public $activeFilters;

	/**
	 * Is this view an Empty State.
	 *
	 * @var   bool
	 *
	 * @since  1.0.0
	 */
	private $isEmptyState = false;

	/**
	 * Display the view.
	 *
	 * @param   string  $tpl  The name of the template file to parse.
	 *
	 * @return  void
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function display($tpl = null)
	{
		$this->state         = $this->get('State');
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		// Set empty state
		if (empty($this->items) && $this->isEmptyState = $this->get('IsEmptyState'))
		{
			$this->setLayout('emptystate');
		}

		// Add title and toolbar
		$this->addToolbar();

		// Load languages
		ReviewsHelper::loadPluginsLanguages();

		// Check for errors
		if (count($errors = $this->get('Errors'))) throw new \Exception(implode('\n', $errors), 500);

		parent::display($tpl);
	}

	/**
	 * Add title and toolbar.
	 *
	 * @since  1.0.0
	 */
	protected function addToolbar()
	{
		$canDo   = ReviewsHelper::getActions('com_radicalreviews', 'reviews');
		$user    = $this->getCurrentUser();
		$toolbar = Factory::getContainer()->get(ToolbarFactoryInterface::class)->createToolbar('toolbar');

		// Set page title
		ToolbarHelper::title(Text::_('COM_RADICALREVIEWS') . ': '
			. Text::_('COM_RADICALREVIEWS_REVIEWS_TITLE'), 'comments');

		// Add create button
		if ($canDo->get('core.create')
			|| \count($user->getAuthorisedCategories('com_radicalreviews', 'core.create')) > 0)
		{
			ToolbarHelper::addNew('review.add');
		}

		// Add publish & unpublish buttons
		if (!$this->isEmptyState && $canDo->get('core.edit.state'))
		{
			ToolbarHelper::publish('reviews.publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('reviews.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}

		// Add delete button
		if (!$this->isEmptyState && $canDo->get('core.delete'))
		{
			ToolbarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'reviews.delete');
		}

		// Add preferences button
		if (!$this->isEmptyState && $canDo->get('core.admin') || $canDo->get('core.options'))
		{
			ToolbarHelper::preferences('com_radicalreviews');
		}
	}

	/**
	 * Returns an array of fields the table can be sorted by.
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value.
	 *
	 * @since  1.0.0
	 */
	protected function getSortFields()
	{
		return array(
			'r.id'      => Text::_('JGRID_HEADING_ID'),
			'r.created' => Text::_('COM_RADICALREVIEWS_DATE'),
			'r.rating'  => Text::_('COM_RADICALREVIEWS_RATING')
		);
	}
}