<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\RadicalReviews\Administrator\Helper\MediaHelper;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  object $item Review item object.
 *
 */

?>

<div class="uk-card uk-card-secondary uk-margin-bottom uk-card-body uk-card-small">
    <div class="uk-child-width-expand@m uk-grid-match" uk-grid="">
        <div class="uk-width-1-1">
			<?php if (!empty($item->media)): ?>
                <div class="uk-grid-small uk-child-width-auto" uk-grid="" uk-lightbox="">
					<?php foreach ($item->media as $src): ?>
                        <div>
                            <a href="/<?php echo ltrim($src, '/'); ?>" class="uk-display-block uk-cover-container"
                               style="width:100px ; height: 100px ;">
                                <?php if (MediaHelper::getInstance()->checkMedia(JPATH_ROOT . '/' . $src) === 'image') : ?>
								    <?php echo HTMLHelper::image($src, htmlspecialchars($item->object->title),
									    array('uk-cover' => '')); ?>
                                <?php else : ?>
                                    <video src="/<?php echo $src; ?>" uk-cover uk-video="autoplay: false;"></video>
                                <?php endif; ?>
                            </a>
                        </div>
					<?php endforeach; ?>
                </div>
			<?php endif; ?>
        </div>
        <div>
            <div>
				<?php
				$text = '';
				foreach (preg_split('/\r\n|\r|\n/', $item->text) as $line)
				{
					if (trim($line)) $text .= '<p>' . $line . '</p>';
				}
				echo $text; ?>
            </div>
            <div class="uk-margin-small-top uk-child-width-1-2@s uk-flex-bottom" uk-grid="">
                <div radicalreviews-rating="container">
                    <div class="uk-flex uk-flex-middle">
						<?php for ($i = 1; $i <= 5; $i++): ?>
                            <span radicalreviews-rating="star" data-value="<?php echo $i; ?>"
                                  data-checked="<?php echo ($i <= $item->rating) ? 'true' : 'false'; ?>"
                                  data-active="true" class="uk-h2 uk-margin-remove"></span>
						<?php endfor; ?>
                        <span class="uk-margin-remove uk-text-muted">(<?php echo $item->rating; ?>)</span>
                    </div>
                </div>
                <div class="uk-text-meta uk-text-right@s">
                    <div><?php echo $item->name; ?></div>
                    <div>
						<?php echo HTMLHelper::date($item->created, Text::_('DATE_FORMAT_LC3')); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>