/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!**************************************************************!*\
  !*** ./com_radicalreviews/es6/administrator/field/media.es6 ***!
  \**************************************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('[radicalreviews-media="container"]').forEach(function (container) {
    var upload = container.querySelector('[radicalreviews-media="upload"]'),
      grid = container.querySelector('[radicalreviews-media="grid"]'),
      label = upload.querySelector('label'),
      iconAdd = label.querySelector('[radicalreviews-media="icon-add"]'),
      iconLoading = label.querySelector('[radicalreviews-media="icon-loading"]'),
      field = upload.querySelector('input'),
      error = container.querySelector('[radicalreviews-media="error"]'),
      errorText = error.querySelector('.error-text');
    label.addEventListener('dragenter', preventDefaults, false);
    label.addEventListener('dragover', preventDefaults, false);
    label.addEventListener('dragleave', preventDefaults, false);
    label.addEventListener('drop', preventDefaults, false);
    label.addEventListener('dragenter', highlightUpload, false);
    label.addEventListener('dragover', highlightUpload, false);
    label.addEventListener('dragleave', unHighlightUpload, false);
    label.addEventListener('drop', unHighlightUpload, false);

    // Drop event
    label.addEventListener('drop', function (element) {
      var files = element.dataTransfer.files;
      addMedia(files, 0);
    });

    // Change event
    field.addEventListener('change', function (element) {
      preventDefaults(element);
      var files = element.target.files;
      addMedia(files, 0);
    });

    // Upload complete event
    document.addEventListener('onMediaUploadComplete', function (event) {
      var index = event.detail.index + 1,
        files = event.detail.files;
      console.info('index - ' + index);
      console.info('length - ' + files.length);
      if (index === files.length) {
        return;
      }
      addMedia(files, index);
    });

    // Stop function
    function preventDefaults(e) {
      e.preventDefault();
      e.stopPropagation();
    }

    // Set highlight
    function highlightUpload() {
      label.classList.add('dragend');
    }

    // Unset highlight
    function unHighlightUpload() {
      label.classList.remove('dragend');
    }
    function addMedia(files, index) {
      var file = files[index];
      if (checkLimit() && file) {
        error.setAttribute('hidden', '');
        label.setAttribute('hidden', '');
        toggleHidden(iconAdd);
        toggleHidden(iconLoading);
        var request = new XMLHttpRequest(),
          requestUrl = container.closest('form').getAttribute('action'),
          formData = new FormData();
        formData.set('task', 'review.checkMedia');
        formData.append('media[]', file);
        request.open('POST', requestUrl);
        request.send(formData);
        request.onreadystatechange = function () {
          if (this.readyState === 4 && this.status === 200) {
            var response = false;
            try {
              response = JSON.parse(this.response);
            } catch (e) {
              response = false;
              errorText.innerHTML = e.message;
              error.removeAttribute('hidden');
              return;
            }
            if (response.success) {
              var mediaType = response.data,
                newParent = document.createElement('div');
              newParent.innerHTML = container.querySelector('[radicalreviews-media="clone"]').innerHTML;
              var newElement = newParent.querySelector('[radicalreviews-media="file"]'),
                newInput = newElement.querySelector('input');
              if (mediaType === 'image') {
                newMedia = newElement.querySelector('img');
                newElement.querySelector('video').remove();
              } else {
                newMedia = newElement.querySelector('video');
                newElement.querySelector('img').remove();
              }

              // Append media type
              // newInput.parentNode.append(newMedia);

              var reader = new FileReader();
              reader.readAsDataURL(file);
              reader.onloadend = function () {
                newMedia.src = reader.result;
              };

              // Set filelist from single file
              dataTransfer = new DataTransfer();
              dataTransfer.items.add(file);
              newInput.files = dataTransfer.files;
              newInput.setAttribute('name', newInput.getAttribute('data-name'));
              newElement.setAttribute('data-media', 'true');
              grid.insertBefore(newElement, upload.nextSibling);
              loadActions(newElement);
              var empties = container.querySelectorAll('[radicalreviews-media="empty"]:not([hidden])');
              if (empties.length > 0) empties[0].setAttribute('hidden', '');
              document.dispatchEvent(new CustomEvent('onMediaUploadComplete', {
                detail: {
                  index: index,
                  files: files
                }
              }));
            } else {
              errorText.innerHTML = response.message;
              error.removeAttribute('hidden');
            }
          } else if (this.readyState === 4 && this.status !== 200) {
            errorText.innerHTML = request.status + ' ' + request.message;
            error.removeAttribute('hidden');
          }
          if (this.readyState === 3) {
            toggleHidden(iconAdd);
            toggleHidden(iconLoading);
          }
        };
      }
    }

    // Check limit
    function checkLimit() {
      var limit = parseInt(container.getAttribute('data-limit')),
        exists = container.querySelectorAll('[radicalreviews-media="file"][data-media="true"]').length;
      return exists < limit;
    }

    // Toggle visibility
    function toggleHidden(element) {
      if (element.hasAttribute('hidden')) {
        element.removeAttribute('hidden');
      } else {
        element.setAttribute('hidden', '');
      }
    }

    // Load remove actions
    function loadActions(newElement) {
      newElement.querySelectorAll('[radicalreviews-media="file"][data-media="true"] [radicalreviews-media="remove"]').forEach(function (button) {
        button.addEventListener('click', function (event) {
          event.preventDefault();
          button.closest('[radicalreviews-media="file"]').remove();

          // Clear Filelist
          field.value = null;

          // Show empties
          var empties = container.querySelectorAll('[radicalreviews-media="empty"][hidden]');
          if (empties.length > 0) empties[0].removeAttribute('hidden');
        });
      });
    }

    // Event for delete button
    document.querySelectorAll('[radicalreviews-media="file"][data-media="true"] [radicalreviews-media="delete"]').forEach(function (button) {
      button.addEventListener('click', function (event) {
        event.preventDefault();
        var formData = new FormData();
        formData.set('path', button.getAttribute('data-path'));
        Joomla.request({
          url: 'index.php?option=com_radicalreviews&task=review.deleteMedia',
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            button.closest('[radicalreviews-media="file"]').remove();

            // Show empties
            var empties = container.querySelectorAll('[radicalreviews-media="empty"][hidden]');
            if (empties.length > 0) empties[0].removeAttribute('hidden');
          },
          onError: function onError(e) {}
        });
      });
    });
  });
});
})();

// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!****************************************************************!*\
  !*** ./com_radicalreviews/scss/administrator/field/media.scss ***!
  \****************************************************************/
// extracted by mini-css-extract-plugin
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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