<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Site\View\Form;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalReviews\Site\Helper\ReviewsHelper;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;

class HtmlView extends BaseHtmlView
{
	/**
	 * Model state variables.
	 *
	 * @var  CMSObject
	 *
	 * @since  1.0.0
	 */
	protected $state;

	/**
	 * Form object.
	 *
	 * @var  Form
	 *
	 * @since  1.0.0
	 */
	protected $form;

	/**
	 * Comment object.
	 *
	 * @var  object
	 *
	 * @since   1.0.0
	 */
	protected $item;

	/**
	 * Object.
	 *
	 * @var  object|false
	 *
	 * @since  1.0.0
	 */
	protected $object;

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse.
	 *
	 * @return  mixed  A string if successful, otherwise an Error object.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function display($tpl = null)
	{
		$app              = Factory::getApplication();
		$this->state      = $this->get('State');
		$this->form       = $this->get('Form');
		$this->object     = $this->get('Object');

		// Set Rating value
		$key = 'new_object_review_' . $this->state->get('object.context') . '_' . $this->state->get('object.item_id');

		// Redirect if reviewed by user
		if ($app->getUserState($key))
		{
			$app->enqueueMessage(Text::_('COM_RADICALREVIEWS_ERROR_FORM_REVIEWED'), 'warning');
			$app->redirect(Route::_(RouteHelper::getReviewsRoute($this->state->get('object.item_id'), $this->state->get('object.context')), false), 303);
		}

		if (!$this->object)
		{
			throw new \Exception(Text::_('COM_RADICALREVIEWS_ERROR_OBJECT_NOT_FOUND'), 404);
		}

		// Check for errors
		if (count($errors = $this->get('Errors')))
		{
			throw new \Exception(implode('\n', $errors), 500);
		}

		// Set Rating value
		$key = 'new_object_rating_' . $this->state->get('object.context') . '_' . $this->state->get('object.item_id');

		if ($value = $app->getUserState($key))
		{
			$this->form->setValue('rating', '', $value);
			$this->form->setValue('minus_rating', '', $value);
		}

		// Load plugin language
		$app = Factory::getApplication();
		$app->getLanguage()->load('plg_radicalreviews_' . explode('.' . $this->object->context, 1)[0], JPATH_ADMINISTRATOR);

		// Add js text var
		Text::script('COM_RADICALREVIEWS_ERROR_EMPTY_DATA');
		Text::script('COM_RADICALREVIEWS_REVIEW_SUCCESS');

		// Prepare the document
		$this->_prepareDocument();

		parent::display($tpl);
	}

	/**
	 * Prepare the document.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	protected function _prepareDocument()
	{
		$app = Factory::getApplication();

		// Change breadcrumbs
		$pathway = $app->getPathway();

		$pathwayObject       = new \stdClass();
		$pathwayObject->name = $this->object->title;
		$pathwayObject->link = $this->object->link;
		$pathwayItems[]      = $pathwayObject;

		$pathwayReviews       = new \stdClass();
		$pathwayReviews->name = Text::_('COM_RADICALREVIEWS_REVIEWS');
		$pathwayReviews->link = RouteHelper::getReviewsRoute($this->object->id, $this->object->context);
		$pathwayItems[]       = $pathwayReviews;

		$pathwayItem       = new \stdClass();
		$pathwayItem->name = Text::_('COM_RADICALREVIEWS_REVIEWS_ADD');
		$pathwayItem->link = '';
		$pathwayItems[]    = $pathwayItem;

		$pathway->setPathway($pathwayItems);

		// Set meta title
		$sitename = $app->get('sitename');
		$title    = Text::sprintf('COM_RADICALREVIEWS_REVIEW_TITLE', $this->object->title);

		if ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = Text::sprintf('JPAGETITLE', $sitename, $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = Text::sprintf('JPAGETITLE', $title, $sitename);
		}

		$this->document->setTitle($title);

		// Set robots
		$this->document->setMetadata('robots', 'noindex');
	}
}