<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Helper;

use Joomla\CMS\Association\AssociationExtensionHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Table\Table;
use Joomla\Component\RadicalReviews\Site\Helper\AssociationHelper;

class AssociationsHelper extends AssociationExtensionHelper
{
	/**
	 * The extension name.
	 *
	 * @var array $extension
	 *
	 * @since 1.0.0
	 */
	protected $extension = 'com_radicalreviews';

	/**
	 * Has the extension association support
	 *
	 * @var     bool $associationsSupport
	 *
	 * @since   1.0.0
	 */
	protected $associationsSupport = true;

	/**
	 * Method to get the associations for a given item.
	 *
	 * @param   int     $id    ID of the item.
	 * @param   string  $view  Name of the view.
	 *
	 * @return  array   Array of associations for the item.
	 *
	 * @throws \Exception
	 *
	 * @since  1.0.0
	 */
	public function getAssociationsForItem($id = 0, $view = null): array
	{
		return AssociationHelper::getAssociations($id, $view);
	}
}
