<?php

/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Traits;

use Joomla\CMS\Form\Form;
use Joomla\Event\Event;

\defined('_JEXEC') or die;

trait PluginTrait
{
	/**
	 * Method to change forms.
	 *
	 * @param   Event  $event  The event.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.1.0
	 */
	public function onRadicalReviewsConfigForm(Event $event)
	{
		/** @var Form $form */
		$form = $event->getArgument('form');

		if ($form->getName() === 'com_config.component')
		{
			$path = JPATH_PLUGINS . '/' . $this->_type . '/' . $this->_name;

			Form::addFormPath($path . '/forms');
			Form::addFieldPath($path . '/fields');
			$form->loadFile('config');
		}
	}

	/**
	 * Method to get all contexts.
	 *
	 * @param   Event  $event  The event.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.1.0
	 */
	public function onRadicalReviewsGetContexts(Event $event)
	{
		$result   = $event->getArgument('result', []);
		$result[] = self::CONTEXTS_MAP;

		$event->setArgument('result', $result);
	}
}
