<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalReviews\Administrator\Helper\ReviewsHelper;

$this->document->getWebAssetManager()->usePreset('com_radicalreviews.administrator.form');

$user      = Factory::getApplication()->getIdentity();
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

$ratingClasses = [
	1 => 'danger',
	2 => 'danger',
	3 => 'warning',
	4 => 'success',
	5 => 'success'
];

$columns = 7;

?>
<form action="<?php echo Route::_('index.php?option=com_radicalreviews&view=rating'); ?>" method="post"
      name="adminForm" id="adminForm">
    <div id="j-main-container" class="span10">
		<?php echo LayoutHelper::render('joomla.searchtools.default',
			array('view' => $this, 'options' => array('filtersHidden' => false))); ?>
		<?php if (empty($this->items)) : ?>
            <div class="alert alert-no-items">
				<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
		<?php else : ?>
            <table id="commentsList" class="table table-striped">
                <thead>
                <tr>
                    <th width="1%" class="text-center">
						<?php echo HTMLHelper::_('grid.checkall'); ?>
                    </th>
                    <th class="break-word">
						<?php echo Text::_('COM_RADICALREVIEWS_OBJECT'); ?>
                    </th>
                    <th class="break-word">
						<?php echo Text::_('COM_RADICALREVIEWS_CONTEXT'); ?>
                    </th>
                    <th class="break-word text-center">
						<?php echo HTMLHelper::_('searchtools.sort', 'COM_RADICALREVIEWS_RATING', 'rating',
							$listDirn, $listOrder); ?>
                    </th>
                    <th class="break-word text-center">
						<?php echo HTMLHelper::_('searchtools.sort', 'COM_RADICALREVIEWS_VOTES', 'r.votes',
							$listDirn, $listOrder); ?>
                    </th>
                    <th width="15%" class="break-word text-center">
						<?php echo HTMLHelper::_('searchtools.sort', 'COM_RADICALREVIEWS_DATE_MODIFIED', 'r.modified', $listDirn, $listOrder); ?>
                    </th>
                    <th width="1%" class="break-word text-center">
						<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'r.id', $listDirn, $listOrder); ?>
                    </th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <td colspan="<?php echo $columns; ?>">
                        <div class="uk-clearfix">
                            <div class="pull-right"><?php echo $this->pagination->getResultsCounter(); ?></div>
                            <div class="pull-left"><?php echo $this->pagination->getListFooter(); ?></div>
                        </div>
                    </td>
                </tr>
                </tfoot>
                <tbody>
				<?php foreach ($this->items as $i => $item) : ?>
                    <tr class="row<?php echo $i % 2; ?>" item-id="<?php echo $item->id ?>">
                        <td class="text-center">
							<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                        </td>
                        <td class="break-word">
							<?php if (!empty($item->item_id && $item->object)): ?>
                                <a href="<?php echo $item->object->link; ?>" class="btn btn btn-link <?php echo ($item->object->state !== 1) ? 'disabled' : ''; ?>" target="_blank">
									<?php echo $item->object->title; ?>
                                </a>
							<?php endif; ?>
                        </td>
                        <td class="break-word">
							<?php echo ReviewsHelper::getContextTitle($item->context); ?>
                        </td>
                        <td class="break-word text-center" style="vertical-align: middle">
                            <div>
								<?php for ($i = 1; $i <= 5; $i++): ?>
									<?php if ($i <= $item->rating): ?>
                                        <span style="font-size: 24px"
                                              class="text-<?php echo $ratingClasses[$item->rating]; ?>">★</span>
									<?php else: ?>
                                        <span style="font-size: 24px">☆</span>
									<?php endif; ?>
								<?php endfor; ?>
                            </div>
                            <div class="text-center">
                                <span class="small text-muted">(<?php echo $item->rating; ?>)</span>
                            </div>
                        </td>
                        <td class="text-center break-word">
							<span class="label label-success">
                                <span class="badge bg-primary"><?php echo $item->votes; ?></span>
							</span>
                        </td>
                        <td class="text-center small break-word">
							<?php echo ($item->modified > 0) ? HTMLHelper::_('date', $item->modified,
								Text::_('DATE_FORMAT_LC2')) : '-'; ?>
                        </td>
                        <td class="text-center"><?php echo $item->id; ?></td>
                    </tr>
				<?php endforeach; ?>
                </tbody>
            </table>
		<?php endif; ?>
        <input type="hidden" name="task" value=""/>
        <input type="hidden" name="boxchecked" value="0"/>
		<?php echo HTMLHelper::_('form.token'); ?>
    </div>
</form>