<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalReviews\Administrator\Helper\ReviewsHelper;

$this->document->getWebAssetManager()->usePreset('com_radicalreviews.administrator.form');

?>
<form action="<?php echo Route::_('index.php?option=com_radicalreviews&view=review&id=' . $this->item->id); ?>"
      method="post" id="adminForm" name="adminForm" class="form-validate" enctype="multipart/form-data">
    <div class="main-card">
        <div class="row п-0">
            <div class="col-lg-8">
				<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'general', 'recall' => true, 'breakpoint' => 768]); ?>

                <!-- Content tab -->
				<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'general', Text::_('JGLOBAL_FIELDSET_CONTENT')); ?>
                <fieldset class="form-horizontal form-horizontal-desktop">
					<?php echo $this->form->renderFieldset('content'); ?>
                </fieldset>
				<?php echo HTMLHelper::_('uitab.endTab'); ?>

				<?php echo HTMLHelper::_('uitab.endTabSet'); ?>
            </div>
            <div class="col-lg-4">
                <div class="form-vertical p-3">
					<?php echo LayoutHelper::render('components.radicalreviews.administrator.fieldset',
						array('form' => $this->form, 'fieldset' => 'global')); ?>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value=""/>
        <input type="hidden" name="return" value="<?php echo Factory::getApplication()->input->getCmd('return'); ?>"/>
		<?php echo HTMLHelper::_('form.token'); ?>
        <div id="preloader" style="display: none">
            <p class="center">
				<?php echo HTMLHelper::image('jui/ajax-loader.gif', '', null, true); ?>
            </p>
        </div>
    </div>
</form>