<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalreviews');
$assets->usePreset('com_radicalreviews.site.field.rating');

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string  $autocomplete   Autocomplete attribute for the field.
 * @var   boolean $autofocus      Is autofocus enabled?
 * @var   string  $class          Classes for the input.
 * @var   string  $description    Description of the field.
 * @var   boolean $disabled       Is this field disabled?
 * @var   string  $group          Group the field belongs to. <fields> section in form XML.
 * @var   boolean $hidden         Is this field hidden in the form?
 * @var   string  $hint           Placeholder for the field.
 * @var   string  $id             DOM id of the field.
 * @var   string  $label          Label of the field.
 * @var   string  $labelclass     Classes to apply to the label.
 * @var   boolean $multiple       Does this field support multiple values?
 * @var   string  $name           Name of the input field.
 * @var   string  $onchange       Onchange attribute for the field.
 * @var   string  $onclick        Onclick attribute for the field.
 * @var   string  $pattern        Pattern (Reg Ex) of value of the form field.
 * @var   boolean $readonly       Is this field read only?
 * @var   boolean $repeat         Allows extensions to duplicate elements.
 * @var   boolean $required       Is this field required?
 * @var   integer $size           Size attribute of the input.
 * @var   boolean $spellcheck     Spellcheck state for the form field.
 * @var   string  $validate       Validation rules to apply.
 * @var   array   $value          Value attribute of the field.
 * @var   array   $checkedOptions Options that will be set as checked.
 * @var   boolean $hasValue       Has this field a value assigned?
 * @var   array   $options        Options available for this field.
 * @var   array   $inputType      Options available for this field.
 * @var   string  $accept         File types that are accepted.
 * @var   string  $dataAttribute  Miscellaneous data attributes preprocessed for HTML output
 * @var   array   $dataAttributes Miscellaneous data attribute for eg, data-*.
 * @var   string  $dirname        The directory name
 * @var   string  $addonBefore    The text to use in a bootstrap input group prepend
 * @var   string  $addonAfter     The text to use in a bootstrap input group append
 * @var   int     $item_id        Object item id.
 * @var   string  $context        Object context.
 */

$value = (!empty($value)) ? ceil((int) $value) : 0;
$hint  = (!empty($hint)) ? $hint : '';

?>
<div id="<?php echo $id . '_container'; ?>" input-rating="container"
     data-active="<?php echo empty($value) ? 'true' : 'false'; ?>"
     data-voted="<?php echo $value ?>"
     data-item_id="<?php echo $item_id; ?>"
     data-context="<?php echo $context; ?>">
    <div radicalreviews-rating="container">
        <div class="uk-flex uk-flex-middle">
			<?php for ($i = 1; $i <= 5; $i++): ?>
                <span radicalreviews-rating="star" data-value="<?php echo $i; ?>" data-active="true"
                      class="uk-h2 uk-margin-remove"
                      data-checked="<?php echo ($i <= $value) ? 'true' : 'false'; ?>"></span>
			<?php endfor; ?>
        </div>
    </div>
    <input id="<?php echo $id; ?>" type="hidden" name="<?php echo $name; ?>" value="<?php echo $value; ?>"
           input-rating="field" placeholder="<?php echo $hint; ?>">
</div>