/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!***************************************************************!*\
  !*** ./com_radicalreviews/es6/administrator/field/images.es6 ***!
  \***************************************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('[input-images="container"]').forEach(function (container) {
    var upload = container.querySelector('[input-images="upload"]'),
      grid = container.querySelector('[input-images="grid"]'),
      label = upload.querySelector('label'),
      field = upload.querySelector('input'),
      loading = upload.querySelector('.loading'),
      error = container.querySelector('[input-images="error"]'),
      errorText = error.querySelector('.error-text');
    label.addEventListener('dragenter', preventDefaults, false);
    label.addEventListener('dragover', preventDefaults, false);
    label.addEventListener('dragleave', preventDefaults, false);
    label.addEventListener('drop', preventDefaults, false);
    label.addEventListener('dragenter', highlightUpload, false);
    label.addEventListener('dragover', highlightUpload, false);
    label.addEventListener('dragleave', unHighlightUpload, false);
    label.addEventListener('drop', unHighlightUpload, false);
    label.addEventListener('drop', function (element) {
      var files = element.dataTransfer.files;
      addImage(files[0], 0);
      document.addEventListener('onImageUploadComplete', function (event) {
        var index = event.detail.index + 1;
        if (index === files.length) {
          return;
        }
        addImage(files[index], index);
      });
    });
    field.addEventListener('change', function (element) {
      preventDefaults(element);
      var files = element.target.files;
      addImage(files[0], 0);
      document.addEventListener('onImageUploadComplete', function (event) {
        var index = event.detail.index + 1;
        if (index === field.files.length) {
          return;
        }
        addImage(files[index], index);
      });
    });

    // Stop function
    function preventDefaults(e) {
      e.preventDefault();
      e.stopPropagation();
    }

    // Set highlight
    function highlightUpload() {
      label.classList.add('dragend');
    }

    // Unset highlight
    function unHighlightUpload() {
      label.classList.remove('dragend');
    }
    function addImage(file, index) {
      if (checkLimit() && file) {
        error.setAttribute('hidden', '');
        label.setAttribute('hidden', '');
        loading.removeAttribute('hidden');
        var request = new XMLHttpRequest(),
          requestUrl = container.closest('form').getAttribute('action'),
          formData = new FormData();
        formData.set('task', 'review.checkImage');
        formData.append('images[]', file);
        request.open('POST', requestUrl);
        request.send(formData);
        request.onreadystatechange = function () {
          if (this.readyState === 4 && this.status === 200) {
            var response = false;
            try {
              response = JSON.parse(this.response);
            } catch (e) {
              response = false;
              errorText.innerHTML = e.message;
              error.removeAttribute('hidden');
              return;
            }
            if (response.success) {
              var newParent = document.createElement('div');
              newParent.innerHTML = container.querySelector('[input-images="clone"]').innerHTML;
              var newElement = newParent.querySelector('[input-images="file"]'),
                newImage = newElement.querySelector('img'),
                newInput = newElement.querySelector('input');
              var reader = new FileReader();
              reader.readAsDataURL(file);
              reader.onloadend = function () {
                newImage.src = reader.result;
              };

              // Set filelist from single file
              dataTransfer = new DataTransfer();
              dataTransfer.items.add(file);
              newInput.files = dataTransfer.files;
              newInput.setAttribute('name', newInput.getAttribute('data-name'));
              newElement.setAttribute('data-image', 'true');
              grid.insertBefore(newElement, upload.nextSibling);
              loadActions(newElement);
              var empties = container.querySelectorAll('[input-images="empty"]:not([hidden])');
              if (empties.length > 0) empties[0].setAttribute('hidden', '');
              document.dispatchEvent(new CustomEvent('onImageUploadComplete', {
                detail: {
                  index: index
                }
              }));
            } else {
              errorText.innerHTML = response.message;
              error.removeAttribute('hidden');
            }
          } else if (this.readyState === 4 && this.status !== 200) {
            errorText.innerHTML = request.status + ' ' + request.message;
            error.removeAttribute('hidden');
          }
          if (this.readyState === 3) {
            label.removeAttribute('hidden');
            loading.setAttribute('hidden', '');
          }
        };
      }
    }

    // Check limit
    function checkLimit() {
      var limit = parseInt(container.getAttribute('data-limit')),
        exists = container.querySelectorAll('[input-images="file"][data-image="true"]').length;
      return exists < limit;
    }

    // Load remove actions
    function loadActions(newElement) {
      newElement.querySelectorAll('[input-images="file"][data-image="true"] [input-images="remove"]').forEach(function (button) {
        button.addEventListener('click', function (event) {
          event.preventDefault();
          button.closest('[input-images="file"]').remove();

          // Clear Filelist
          field.value = '';

          // Show empties
          var empties = container.querySelectorAll('[input-images="empty"][hidden]');
          if (empties.length > 0) empties[0].removeAttribute('hidden');
        });
      });
    }

    // Event for delete button
    document.querySelectorAll('[input-images="file"][data-image="true"] [input-images="delete"]').forEach(function (button) {
      button.addEventListener('click', function (event) {
        event.preventDefault();
        var formData = new FormData();
        formData.set('path', button.getAttribute('data-path'));
        Joomla.request({
          url: 'index.php?option=com_radicalreviews&task=review.delete_image',
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            button.closest('[input-images="file"]').remove();

            // Show empties
            var empties = container.querySelectorAll('[input-images="empty"][hidden]');
            if (empties.length > 0) empties[0].removeAttribute('hidden');
          },
          onError: function onError(e) {}
        });
      });
    });
  });
});
})();

// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!*****************************************************************!*\
  !*** ./com_radicalreviews/scss/administrator/field/images.scss ***!
  \*****************************************************************/
// extracted by mini-css-extract-plugin
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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