/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!*************************************************!*\
  !*** ./com_radicalreviews/es6/field/images.es6 ***!
  \*************************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('[input-images="container"]').forEach(function (container) {
    var upload = container.querySelector('[input-images="upload"]'),
      label = upload.querySelector('label'),
      field = upload.querySelector('input'),
      loading = upload.querySelector('.loading'),
      error = container.querySelector('[input-images="error"]'),
      errorText = error.querySelector('.error-text');
    label.addEventListener('dragenter', preventDefaults, false);
    label.addEventListener('dragover', preventDefaults, false);
    label.addEventListener('dragleave', preventDefaults, false);
    label.addEventListener('drop', preventDefaults, false);
    label.addEventListener('dragenter', highlightUpload, false);
    label.addEventListener('dragover', highlightUpload, false);
    label.addEventListener('dragleave', unHighlightUpload, false);
    label.addEventListener('drop', unHighlightUpload, false);
    label.addEventListener('drop', function (element) {
      var files = element.dataTransfer.files;
      addImage(files[0], 0);
      document.addEventListener('onImageUploadComplete', function (event) {
        var index = event.detail.index + 1;
        if (index === files.length) {
          return;
        }
        addImage(files[index], index);
      });
    });
    field.addEventListener('change', function (element) {
      preventDefaults(element);
      var files = element.target.files;
      addImage(files[0], 0);
      document.addEventListener('onImageUploadComplete', function (event) {
        var index = event.detail.index + 1;
        if (index === field.files.length) {
          return;
        }
        addImage(files[index], index);
      });
    });

    // Stop function
    function preventDefaults(e) {
      e.preventDefault();
      e.stopPropagation();
    }

    // Set highlight
    function highlightUpload() {
      label.classList.add('dragend');
    }

    // Unset highlight
    function unHighlightUpload() {
      label.classList.remove('dragend');
    }
    function addImage(file, index) {
      if (checkLimit() && file) {
        error.setAttribute('hidden', '');
        label.setAttribute('hidden', '');
        loading.removeAttribute('hidden');
        var request = new XMLHttpRequest(),
          requestUrl = container.closest('form').getAttribute('action'),
          formData = new FormData();
        formData.set('task', 'review.checkImage');
        formData.append('images[]', file);
        request.open('POST', requestUrl);
        request.send(formData);
        request.onreadystatechange = function () {
          if (this.readyState === 4 && this.status === 200) {
            var response = false;
            try {
              response = JSON.parse(this.response);
            } catch (e) {
              response = false;
              errorText.innerHTML = e.message;
              error.removeAttribute('hidden');
              return;
            }
            if (response.success) {
              var newParent = document.createElement('div');
              newParent.innerHTML = container.querySelector('[input-images="clone"]').innerHTML;
              var newElement = newParent.querySelector('[input-images="file"]'),
                newImage = newElement.querySelector('img'),
                newInput = newElement.querySelector('input');
              var reader = new FileReader();
              reader.readAsDataURL(file);
              reader.onloadend = function () {
                newImage.src = reader.result;
              };

              // Set filelist from single file
              dataTransfer = new DataTransfer();
              dataTransfer.items.add(file);
              newInput.files = dataTransfer.files;
              newInput.setAttribute('name', newInput.getAttribute('data-name'));
              newElement.setAttribute('data-image', 'true');
              container.insertBefore(newElement, upload.nextSibling);
              loadActions(newElement);
              var empties = container.querySelectorAll('[input-images="empty"]:not([hidden])');
              if (empties.length > 0) empties[0].setAttribute('hidden', '');
              document.dispatchEvent(new CustomEvent('onImageUploadComplete', {
                detail: {
                  index: index
                }
              }));
            } else {
              errorText.innerHTML = response.message;
              error.removeAttribute('hidden');
            }
          } else if (this.readyState === 4 && this.status !== 200) {
            errorText.innerHTML = request.status + ' ' + request.message;
            error.removeAttribute('hidden');
          }
          if (this.readyState === 3) {
            label.removeAttribute('hidden');
            loading.setAttribute('hidden', '');
          }
        };
      }
    }
    function checkLimit() {
      var limit = parseInt(container.getAttribute('data-limit')),
        exists = container.querySelectorAll('[input-images="file"][data-image="true"]').length;
      return exists < limit;
    }
    function loadActions(newElement) {
      newElement.querySelectorAll('[input-images="file"][data-image="true"] [input-images="delete"]').forEach(function (button) {
        button.addEventListener('click', function (event) {
          event.preventDefault();
          button.closest('[input-images="file"]').remove();

          // Clear Filelist
          field.value = '';

          // Show empties
          var empties = container.querySelectorAll('[input-images="empty"][hidden]');
          if (empties.length > 0) empties[0].removeAttribute('hidden');
        });
      });
    }
  });
});
})();

// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!***************************************************!*\
  !*** ./com_radicalreviews/scss/field/images.scss ***!
  \***************************************************/
// extracted by mini-css-extract-plugin
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoianMvZmllbGQtaW1hZ2VzLmpzIiwibWFwcGluZ3MiOiI7OztVQUFBO1VBQ0E7O1VBRUE7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7O1VBRUE7VUFDQTs7VUFFQTtVQUNBO1VBQ0E7Ozs7Ozs7Ozs7QUN0QkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQUEsUUFBUSxDQUFDQyxnQkFBZ0IsQ0FBQyxrQkFBa0IsRUFBRSxZQUFZO0VBQ3RERCxRQUFRLENBQUNFLGdCQUFnQixDQUFDLDRCQUE0QixDQUFDLENBQUNDLE9BQU8sQ0FBQyxVQUFVQyxTQUFTLEVBQUU7SUFDakYsSUFBSUMsTUFBTSxHQUFHRCxTQUFTLENBQUNFLGFBQWEsQ0FBQyx5QkFBeUIsQ0FBQztNQUMzREMsS0FBSyxHQUFHRixNQUFNLENBQUNDLGFBQWEsQ0FBQyxPQUFPLENBQUM7TUFDckNFLEtBQUssR0FBR0gsTUFBTSxDQUFDQyxhQUFhLENBQUMsT0FBTyxDQUFDO01BQ3JDRyxPQUFPLEdBQUdKLE1BQU0sQ0FBQ0MsYUFBYSxDQUFDLFVBQVUsQ0FBQztNQUMxQ0ksS0FBSyxHQUFHTixTQUFTLENBQUNFLGFBQWEsQ0FBQyx3QkFBd0IsQ0FBQztNQUN6REssU0FBUyxHQUFHRCxLQUFLLENBQUNKLGFBQWEsQ0FBQyxhQUFhLENBQUM7SUFFbERDLEtBQUssQ0FBQ04sZ0JBQWdCLENBQUMsV0FBVyxFQUFFVyxlQUFlLEVBQUUsS0FBSyxDQUFDO0lBQzNETCxLQUFLLENBQUNOLGdCQUFnQixDQUFDLFVBQVUsRUFBRVcsZUFBZSxFQUFFLEtBQUssQ0FBQztJQUMxREwsS0FBSyxDQUFDTixnQkFBZ0IsQ0FBQyxXQUFXLEVBQUVXLGVBQWUsRUFBRSxLQUFLLENBQUM7SUFDM0RMLEtBQUssQ0FBQ04sZ0JBQWdCLENBQUMsTUFBTSxFQUFFVyxlQUFlLEVBQUUsS0FBSyxDQUFDO0lBQ3RETCxLQUFLLENBQUNOLGdCQUFnQixDQUFDLFdBQVcsRUFBRVksZUFBZSxFQUFFLEtBQUssQ0FBQztJQUMzRE4sS0FBSyxDQUFDTixnQkFBZ0IsQ0FBQyxVQUFVLEVBQUVZLGVBQWUsRUFBRSxLQUFLLENBQUM7SUFDMUROLEtBQUssQ0FBQ04sZ0JBQWdCLENBQUMsV0FBVyxFQUFFYSxpQkFBaUIsRUFBRSxLQUFLLENBQUM7SUFDN0RQLEtBQUssQ0FBQ04sZ0JBQWdCLENBQUMsTUFBTSxFQUFFYSxpQkFBaUIsRUFBRSxLQUFLLENBQUM7SUFFeERQLEtBQUssQ0FBQ04sZ0JBQWdCLENBQUMsTUFBTSxFQUFFLFVBQVVjLE9BQU8sRUFBRTtNQUM5QyxJQUFJQyxLQUFLLEdBQUdELE9BQU8sQ0FBQ0UsWUFBWSxDQUFDRCxLQUFLO01BRXRDRSxRQUFRLENBQUNGLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7TUFFckJoQixRQUFRLENBQUNDLGdCQUFnQixDQUFDLHVCQUF1QixFQUFFLFVBQVVrQixLQUFLLEVBQUU7UUFDaEUsSUFBSUMsS0FBSyxHQUFHRCxLQUFLLENBQUNFLE1BQU0sQ0FBQ0QsS0FBSyxHQUFHLENBQUM7UUFFbEMsSUFBSUEsS0FBSyxLQUFLSixLQUFLLENBQUNNLE1BQU0sRUFBRTtVQUN4QjtRQUNKO1FBRUFKLFFBQVEsQ0FBQ0YsS0FBSyxDQUFDSSxLQUFLLENBQUMsRUFBRUEsS0FBSyxDQUFDO01BQ2pDLENBQUMsQ0FBQztJQUNOLENBQUMsQ0FBQztJQUVGWixLQUFLLENBQUNQLGdCQUFnQixDQUFDLFFBQVEsRUFBRSxVQUFVYyxPQUFPLEVBQUU7TUFDaERILGVBQWUsQ0FBQ0csT0FBTyxDQUFDO01BRXhCLElBQUlDLEtBQUssR0FBR0QsT0FBTyxDQUFDUSxNQUFNLENBQUNQLEtBQUs7TUFFaENFLFFBQVEsQ0FBQ0YsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztNQUVyQmhCLFFBQVEsQ0FBQ0MsZ0JBQWdCLENBQUMsdUJBQXVCLEVBQUUsVUFBVWtCLEtBQUssRUFBRTtRQUNoRSxJQUFJQyxLQUFLLEdBQUdELEtBQUssQ0FBQ0UsTUFBTSxDQUFDRCxLQUFLLEdBQUcsQ0FBQztRQUVsQyxJQUFJQSxLQUFLLEtBQUtaLEtBQUssQ0FBQ1EsS0FBSyxDQUFDTSxNQUFNLEVBQUU7VUFDOUI7UUFDSjtRQUVBSixRQUFRLENBQUNGLEtBQUssQ0FBQ0ksS0FBSyxDQUFDLEVBQUVBLEtBQUssQ0FBQztNQUNqQyxDQUFDLENBQUM7SUFDTixDQUFDLENBQUM7O0lBR0Y7SUFDQSxTQUFTUixlQUFlLENBQUNZLENBQUMsRUFBRTtNQUN4QkEsQ0FBQyxDQUFDQyxjQUFjLEVBQUU7TUFDbEJELENBQUMsQ0FBQ0UsZUFBZSxFQUFFO0lBQ3ZCOztJQUVBO0lBQ0EsU0FBU2IsZUFBZSxHQUFHO01BQ3ZCTixLQUFLLENBQUNvQixTQUFTLENBQUNDLEdBQUcsQ0FBQyxTQUFTLENBQUM7SUFDbEM7O0lBRUE7SUFDQSxTQUFTZCxpQkFBaUIsR0FBRztNQUN6QlAsS0FBSyxDQUFDb0IsU0FBUyxDQUFDRSxNQUFNLENBQUMsU0FBUyxDQUFDO0lBQ3JDO0lBRUEsU0FBU1gsUUFBUSxDQUFDWSxJQUFJLEVBQUVWLEtBQUssRUFBRTtNQUMzQixJQUFJVyxVQUFVLEVBQUUsSUFBSUQsSUFBSSxFQUFFO1FBQ3RCcEIsS0FBSyxDQUFDc0IsWUFBWSxDQUFDLFFBQVEsRUFBRSxFQUFFLENBQUM7UUFDaEN6QixLQUFLLENBQUN5QixZQUFZLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQztRQUNoQ3ZCLE9BQU8sQ0FBQ3dCLGVBQWUsQ0FBQyxRQUFRLENBQUM7UUFFakMsSUFBSUMsT0FBTyxHQUFHLElBQUlDLGNBQWMsRUFBRTtVQUM5QkMsVUFBVSxHQUFHaEMsU0FBUyxDQUFDaUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDQyxZQUFZLENBQUMsUUFBUSxDQUFDO1VBQzdEQyxRQUFRLEdBQUcsSUFBSUMsUUFBUSxFQUFFO1FBQzdCRCxRQUFRLENBQUNFLEdBQUcsQ0FBQyxNQUFNLEVBQUUsbUJBQW1CLENBQUM7UUFDekNGLFFBQVEsQ0FBQ0csTUFBTSxDQUFDLFVBQVUsRUFBRVosSUFBSSxDQUFDO1FBRWpDSSxPQUFPLENBQUNTLElBQUksQ0FBQyxNQUFNLEVBQUVQLFVBQVUsQ0FBQztRQUNoQ0YsT0FBTyxDQUFDVSxJQUFJLENBQUNMLFFBQVEsQ0FBQztRQUN0QkwsT0FBTyxDQUFDVyxrQkFBa0IsR0FBRyxZQUFZO1VBQ3JDLElBQUksSUFBSSxDQUFDQyxVQUFVLEtBQUssQ0FBQyxJQUFJLElBQUksQ0FBQ0MsTUFBTSxLQUFLLEdBQUcsRUFBRTtZQUM5QyxJQUFJQyxRQUFRLEdBQUcsS0FBSztZQUNwQixJQUFJO2NBQ0FBLFFBQVEsR0FBR0MsSUFBSSxDQUFDQyxLQUFLLENBQUMsSUFBSSxDQUFDRixRQUFRLENBQUM7WUFDeEMsQ0FBQyxDQUFDLE9BQU94QixDQUFDLEVBQUU7Y0FDUndCLFFBQVEsR0FBRyxLQUFLO2NBQ2hCckMsU0FBUyxDQUFDd0MsU0FBUyxHQUFHM0IsQ0FBQyxDQUFDNEIsT0FBTztjQUMvQjFDLEtBQUssQ0FBQ3VCLGVBQWUsQ0FBQyxRQUFRLENBQUM7Y0FDL0I7WUFDSjtZQUVBLElBQUllLFFBQVEsQ0FBQ0ssT0FBTyxFQUFFO2NBQ2xCLElBQUlDLFNBQVMsR0FBR3RELFFBQVEsQ0FBQ3VELGFBQWEsQ0FBQyxLQUFLLENBQUM7Y0FDN0NELFNBQVMsQ0FBQ0gsU0FBUyxHQUFHL0MsU0FBUyxDQUFDRSxhQUFhLENBQUMsd0JBQXdCLENBQUMsQ0FBQzZDLFNBQVM7Y0FFakYsSUFBSUssVUFBVSxHQUFHRixTQUFTLENBQUNoRCxhQUFhLENBQUMsdUJBQXVCLENBQUM7Z0JBQzdEbUQsUUFBUSxHQUFHRCxVQUFVLENBQUNsRCxhQUFhLENBQUMsS0FBSyxDQUFDO2dCQUMxQ29ELFFBQVEsR0FBR0YsVUFBVSxDQUFDbEQsYUFBYSxDQUFDLE9BQU8sQ0FBQztjQUdoRCxJQUFJcUQsTUFBTSxHQUFHLElBQUlDLFVBQVUsRUFBRTtjQUM3QkQsTUFBTSxDQUFDRSxhQUFhLENBQUMvQixJQUFJLENBQUM7Y0FDMUI2QixNQUFNLENBQUNHLFNBQVMsR0FBRyxZQUFZO2dCQUMzQkwsUUFBUSxDQUFDTSxHQUFHLEdBQUdKLE1BQU0sQ0FBQ0ssTUFBTTtjQUNoQyxDQUFDOztjQUVEO2NBQ0EvQyxZQUFZLEdBQUcsSUFBSWdELFlBQVksRUFBRTtjQUNqQ2hELFlBQVksQ0FBQ2lELEtBQUssQ0FBQ3RDLEdBQUcsQ0FBQ0UsSUFBSSxDQUFDO2NBRTVCNEIsUUFBUSxDQUFDMUMsS0FBSyxHQUFHQyxZQUFZLENBQUNELEtBQUs7Y0FDbkMwQyxRQUFRLENBQUMxQixZQUFZLENBQUMsTUFBTSxFQUFFMEIsUUFBUSxDQUFDcEIsWUFBWSxDQUFDLFdBQVcsQ0FBQyxDQUFDO2NBRWpFa0IsVUFBVSxDQUFDeEIsWUFBWSxDQUFDLFlBQVksRUFBRSxNQUFNLENBQUM7Y0FDN0M1QixTQUFTLENBQUMrRCxZQUFZLENBQUNYLFVBQVUsRUFBRW5ELE1BQU0sQ0FBQytELFdBQVcsQ0FBQztjQUV0REMsV0FBVyxDQUFDYixVQUFVLENBQUM7Y0FFdkIsSUFBSWMsT0FBTyxHQUFHbEUsU0FBUyxDQUFDRixnQkFBZ0IsQ0FBQyxzQ0FBc0MsQ0FBQztjQUNoRixJQUFJb0UsT0FBTyxDQUFDaEQsTUFBTSxHQUFHLENBQUMsRUFBRWdELE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQ3RDLFlBQVksQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDO2NBRTdEaEMsUUFBUSxDQUFDdUUsYUFBYSxDQUFDLElBQUlDLFdBQVcsQ0FBQyx1QkFBdUIsRUFBRTtnQkFBQ25ELE1BQU0sRUFBRTtrQkFBQ0QsS0FBSyxFQUFFQTtnQkFBSztjQUFDLENBQUMsQ0FBQyxDQUFDO1lBQzlGLENBQUMsTUFBTTtjQUNIVCxTQUFTLENBQUN3QyxTQUFTLEdBQUdILFFBQVEsQ0FBQ0ksT0FBTztjQUN0QzFDLEtBQUssQ0FBQ3VCLGVBQWUsQ0FBQyxRQUFRLENBQUM7WUFDbkM7VUFDSixDQUFDLE1BQU0sSUFBSSxJQUFJLENBQUNhLFVBQVUsS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDQyxNQUFNLEtBQUssR0FBRyxFQUFFO1lBQ3JEcEMsU0FBUyxDQUFDd0MsU0FBUyxHQUFHakIsT0FBTyxDQUFDYSxNQUFNLEdBQUcsR0FBRyxHQUFHYixPQUFPLENBQUNrQixPQUFPO1lBQzVEMUMsS0FBSyxDQUFDdUIsZUFBZSxDQUFDLFFBQVEsQ0FBQztVQUNuQztVQUNBLElBQUksSUFBSSxDQUFDYSxVQUFVLEtBQUssQ0FBQyxFQUFFO1lBQ3ZCdkMsS0FBSyxDQUFDMEIsZUFBZSxDQUFDLFFBQVEsQ0FBQztZQUMvQnhCLE9BQU8sQ0FBQ3VCLFlBQVksQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDO1VBQ3RDO1FBQ0osQ0FBQztNQUNMO0lBQ0o7SUFFQSxTQUFTRCxVQUFVLEdBQUc7TUFDbEIsSUFBSTBDLEtBQUssR0FBR0MsUUFBUSxDQUFDdEUsU0FBUyxDQUFDa0MsWUFBWSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ3REcUMsTUFBTSxHQUFHdkUsU0FBUyxDQUFDRixnQkFBZ0IsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDb0IsTUFBTTtNQUUxRixPQUFPcUQsTUFBTSxHQUFHRixLQUFLO0lBQ3pCO0lBRUEsU0FBU0osV0FBVyxDQUFDYixVQUFVLEVBQUU7TUFDN0JBLFVBQVUsQ0FBQ3RELGdCQUFnQixDQUFDLGtFQUFrRSxDQUFDLENBQUNDLE9BQU8sQ0FBQyxVQUFVeUUsTUFBTSxFQUFFO1FBQ3RIQSxNQUFNLENBQUMzRSxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsVUFBVWtCLEtBQUssRUFBRTtVQUM5Q0EsS0FBSyxDQUFDTSxjQUFjLEVBQUU7VUFDdEJtRCxNQUFNLENBQUN2QyxPQUFPLENBQUMsdUJBQXVCLENBQUMsQ0FBQ1IsTUFBTSxFQUFFOztVQUVoRDtVQUNBckIsS0FBSyxDQUFDcUUsS0FBSyxHQUFHLEVBQUU7O1VBRWhCO1VBQ0EsSUFBSVAsT0FBTyxHQUFHbEUsU0FBUyxDQUFDRixnQkFBZ0IsQ0FBQyxnQ0FBZ0MsQ0FBQztVQUUxRSxJQUFJb0UsT0FBTyxDQUFDaEQsTUFBTSxHQUFHLENBQUMsRUFBRWdELE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQ3JDLGVBQWUsQ0FBQyxRQUFRLENBQUM7UUFDaEUsQ0FBQyxDQUFDO01BQ04sQ0FBQyxDQUFDO0lBQ047RUFDSixDQUFDLENBQUM7QUFDTixDQUFDLENBQUMsQzs7Ozs7Ozs7QUMvS0YsdUMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9yYWRpY2FscmV2aWV3cy93ZWJwYWNrL2Jvb3RzdHJhcCIsIndlYnBhY2s6Ly9yYWRpY2FscmV2aWV3cy8uL2NvbV9yYWRpY2FscmV2aWV3cy9lczYvZmllbGQvaW1hZ2VzLmVzNiIsIndlYnBhY2s6Ly9yYWRpY2FscmV2aWV3cy8uL2NvbV9yYWRpY2FscmV2aWV3cy9zY3NzL2ZpZWxkL2ltYWdlcy5zY3NzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIFRoZSBtb2R1bGUgY2FjaGVcbnZhciBfX3dlYnBhY2tfbW9kdWxlX2NhY2hlX18gPSB7fTtcblxuLy8gVGhlIHJlcXVpcmUgZnVuY3Rpb25cbmZ1bmN0aW9uIF9fd2VicGFja19yZXF1aXJlX18obW9kdWxlSWQpIHtcblx0Ly8gQ2hlY2sgaWYgbW9kdWxlIGlzIGluIGNhY2hlXG5cdHZhciBjYWNoZWRNb2R1bGUgPSBfX3dlYnBhY2tfbW9kdWxlX2NhY2hlX19bbW9kdWxlSWRdO1xuXHRpZiAoY2FjaGVkTW9kdWxlICE9PSB1bmRlZmluZWQpIHtcblx0XHRyZXR1cm4gY2FjaGVkTW9kdWxlLmV4cG9ydHM7XG5cdH1cblx0Ly8gQ3JlYXRlIGEgbmV3IG1vZHVsZSAoYW5kIHB1dCBpdCBpbnRvIHRoZSBjYWNoZSlcblx0dmFyIG1vZHVsZSA9IF9fd2VicGFja19tb2R1bGVfY2FjaGVfX1ttb2R1bGVJZF0gPSB7XG5cdFx0Ly8gbm8gbW9kdWxlLmlkIG5lZWRlZFxuXHRcdC8vIG5vIG1vZHVsZS5sb2FkZWQgbmVlZGVkXG5cdFx0ZXhwb3J0czoge31cblx0fTtcblxuXHQvLyBFeGVjdXRlIHRoZSBtb2R1bGUgZnVuY3Rpb25cblx0X193ZWJwYWNrX21vZHVsZXNfX1ttb2R1bGVJZF0obW9kdWxlLCBtb2R1bGUuZXhwb3J0cywgX193ZWJwYWNrX3JlcXVpcmVfXyk7XG5cblx0Ly8gUmV0dXJuIHRoZSBleHBvcnRzIG9mIHRoZSBtb2R1bGVcblx0cmV0dXJuIG1vZHVsZS5leHBvcnRzO1xufVxuXG4iLCIvKlxuICogQHBhY2thZ2UgICBwa2dfcmFkaWNhbHJldmlld3NcbiAqIEB2ZXJzaW9uICAgX19ERVBMT1lfVkVSU0lPTl9fXG4gKiBAYXV0aG9yICAgIERtaXRyaXkgVmFzeXVrb3YgLSBodHRwczovL2ZpY3Rpb25sYWJzLnJ1XG4gKiBAY29weXJpZ2h0IENvcHlyaWdodCAoYykgMjAyMyBGaWN0aW9ubGFicy4gQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAqIEBsaWNlbnNlICAgR05VL0dQTCBsaWNlbnNlOiBodHRwOi8vd3d3LmdudS5vcmcvY29weWxlZnQvZ3BsLmh0bWxcbiAqIEBsaW5rICAgICAgaHR0cHM6Ly9maWN0aW9ubGFicy5ydS9cbiAqL1xuXG5kb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdET01Db250ZW50TG9hZGVkJywgZnVuY3Rpb24gKCkge1xuICAgIGRvY3VtZW50LnF1ZXJ5U2VsZWN0b3JBbGwoJ1tpbnB1dC1pbWFnZXM9XCJjb250YWluZXJcIl0nKS5mb3JFYWNoKGZ1bmN0aW9uIChjb250YWluZXIpIHtcbiAgICAgICAgbGV0IHVwbG9hZCA9IGNvbnRhaW5lci5xdWVyeVNlbGVjdG9yKCdbaW5wdXQtaW1hZ2VzPVwidXBsb2FkXCJdJyksXG4gICAgICAgICAgICBsYWJlbCA9IHVwbG9hZC5xdWVyeVNlbGVjdG9yKCdsYWJlbCcpLFxuICAgICAgICAgICAgZmllbGQgPSB1cGxvYWQucXVlcnlTZWxlY3RvcignaW5wdXQnKSxcbiAgICAgICAgICAgIGxvYWRpbmcgPSB1cGxvYWQucXVlcnlTZWxlY3RvcignLmxvYWRpbmcnKSxcbiAgICAgICAgICAgIGVycm9yID0gY29udGFpbmVyLnF1ZXJ5U2VsZWN0b3IoJ1tpbnB1dC1pbWFnZXM9XCJlcnJvclwiXScpLFxuICAgICAgICAgICAgZXJyb3JUZXh0ID0gZXJyb3IucXVlcnlTZWxlY3RvcignLmVycm9yLXRleHQnKTtcblxuICAgICAgICBsYWJlbC5hZGRFdmVudExpc3RlbmVyKCdkcmFnZW50ZXInLCBwcmV2ZW50RGVmYXVsdHMsIGZhbHNlKTtcbiAgICAgICAgbGFiZWwuYWRkRXZlbnRMaXN0ZW5lcignZHJhZ292ZXInLCBwcmV2ZW50RGVmYXVsdHMsIGZhbHNlKTtcbiAgICAgICAgbGFiZWwuYWRkRXZlbnRMaXN0ZW5lcignZHJhZ2xlYXZlJywgcHJldmVudERlZmF1bHRzLCBmYWxzZSk7XG4gICAgICAgIGxhYmVsLmFkZEV2ZW50TGlzdGVuZXIoJ2Ryb3AnLCBwcmV2ZW50RGVmYXVsdHMsIGZhbHNlKTtcbiAgICAgICAgbGFiZWwuYWRkRXZlbnRMaXN0ZW5lcignZHJhZ2VudGVyJywgaGlnaGxpZ2h0VXBsb2FkLCBmYWxzZSk7XG4gICAgICAgIGxhYmVsLmFkZEV2ZW50TGlzdGVuZXIoJ2RyYWdvdmVyJywgaGlnaGxpZ2h0VXBsb2FkLCBmYWxzZSk7XG4gICAgICAgIGxhYmVsLmFkZEV2ZW50TGlzdGVuZXIoJ2RyYWdsZWF2ZScsIHVuSGlnaGxpZ2h0VXBsb2FkLCBmYWxzZSk7XG4gICAgICAgIGxhYmVsLmFkZEV2ZW50TGlzdGVuZXIoJ2Ryb3AnLCB1bkhpZ2hsaWdodFVwbG9hZCwgZmFsc2UpO1xuXG4gICAgICAgIGxhYmVsLmFkZEV2ZW50TGlzdGVuZXIoJ2Ryb3AnLCBmdW5jdGlvbiAoZWxlbWVudCkge1xuICAgICAgICAgICAgbGV0IGZpbGVzID0gZWxlbWVudC5kYXRhVHJhbnNmZXIuZmlsZXM7XG5cbiAgICAgICAgICAgIGFkZEltYWdlKGZpbGVzWzBdLCAwKTtcblxuICAgICAgICAgICAgZG9jdW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignb25JbWFnZVVwbG9hZENvbXBsZXRlJywgZnVuY3Rpb24gKGV2ZW50KSB7XG4gICAgICAgICAgICAgICAgbGV0IGluZGV4ID0gZXZlbnQuZGV0YWlsLmluZGV4ICsgMTtcblxuICAgICAgICAgICAgICAgIGlmIChpbmRleCA9PT0gZmlsZXMubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBhZGRJbWFnZShmaWxlc1tpbmRleF0sIGluZGV4KTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcblxuICAgICAgICBmaWVsZC5hZGRFdmVudExpc3RlbmVyKCdjaGFuZ2UnLCBmdW5jdGlvbiAoZWxlbWVudCkge1xuICAgICAgICAgICAgcHJldmVudERlZmF1bHRzKGVsZW1lbnQpO1xuXG4gICAgICAgICAgICBsZXQgZmlsZXMgPSBlbGVtZW50LnRhcmdldC5maWxlcztcblxuICAgICAgICAgICAgYWRkSW1hZ2UoZmlsZXNbMF0sIDApO1xuXG4gICAgICAgICAgICBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdvbkltYWdlVXBsb2FkQ29tcGxldGUnLCBmdW5jdGlvbiAoZXZlbnQpIHtcbiAgICAgICAgICAgICAgICBsZXQgaW5kZXggPSBldmVudC5kZXRhaWwuaW5kZXggKyAxO1xuXG4gICAgICAgICAgICAgICAgaWYgKGluZGV4ID09PSBmaWVsZC5maWxlcy5sZW5ndGgpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIGFkZEltYWdlKGZpbGVzW2luZGV4XSwgaW5kZXgpO1xuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuXG5cbiAgICAgICAgLy8gU3RvcCBmdW5jdGlvblxuICAgICAgICBmdW5jdGlvbiBwcmV2ZW50RGVmYXVsdHMoZSkge1xuICAgICAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAgICAgZS5zdG9wUHJvcGFnYXRpb24oKTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIFNldCBoaWdobGlnaHRcbiAgICAgICAgZnVuY3Rpb24gaGlnaGxpZ2h0VXBsb2FkKCkge1xuICAgICAgICAgICAgbGFiZWwuY2xhc3NMaXN0LmFkZCgnZHJhZ2VuZCcpXG4gICAgICAgIH1cblxuICAgICAgICAvLyBVbnNldCBoaWdobGlnaHRcbiAgICAgICAgZnVuY3Rpb24gdW5IaWdobGlnaHRVcGxvYWQoKSB7XG4gICAgICAgICAgICBsYWJlbC5jbGFzc0xpc3QucmVtb3ZlKCdkcmFnZW5kJylcbiAgICAgICAgfVxuXG4gICAgICAgIGZ1bmN0aW9uIGFkZEltYWdlKGZpbGUsIGluZGV4KSB7XG4gICAgICAgICAgICBpZiAoY2hlY2tMaW1pdCgpICYmIGZpbGUpIHtcbiAgICAgICAgICAgICAgICBlcnJvci5zZXRBdHRyaWJ1dGUoJ2hpZGRlbicsICcnKTtcbiAgICAgICAgICAgICAgICBsYWJlbC5zZXRBdHRyaWJ1dGUoJ2hpZGRlbicsICcnKTtcbiAgICAgICAgICAgICAgICBsb2FkaW5nLnJlbW92ZUF0dHJpYnV0ZSgnaGlkZGVuJyk7XG5cbiAgICAgICAgICAgICAgICBsZXQgcmVxdWVzdCA9IG5ldyBYTUxIdHRwUmVxdWVzdCgpLFxuICAgICAgICAgICAgICAgICAgICByZXF1ZXN0VXJsID0gY29udGFpbmVyLmNsb3Nlc3QoJ2Zvcm0nKS5nZXRBdHRyaWJ1dGUoJ2FjdGlvbicpLFxuICAgICAgICAgICAgICAgICAgICBmb3JtRGF0YSA9IG5ldyBGb3JtRGF0YSgpO1xuICAgICAgICAgICAgICAgIGZvcm1EYXRhLnNldCgndGFzaycsICdyZXZpZXcuY2hlY2tJbWFnZScpXG4gICAgICAgICAgICAgICAgZm9ybURhdGEuYXBwZW5kKCdpbWFnZXNbXScsIGZpbGUpO1xuXG4gICAgICAgICAgICAgICAgcmVxdWVzdC5vcGVuKCdQT1NUJywgcmVxdWVzdFVybCk7XG4gICAgICAgICAgICAgICAgcmVxdWVzdC5zZW5kKGZvcm1EYXRhKTtcbiAgICAgICAgICAgICAgICByZXF1ZXN0Lm9ucmVhZHlzdGF0ZWNoYW5nZSA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHRoaXMucmVhZHlTdGF0ZSA9PT0gNCAmJiB0aGlzLnN0YXR1cyA9PT0gMjAwKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgcmVzcG9uc2UgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmVzcG9uc2UgPSBKU09OLnBhcnNlKHRoaXMucmVzcG9uc2UpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlc3BvbnNlID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZXJyb3JUZXh0LmlubmVySFRNTCA9IGUubWVzc2FnZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBlcnJvci5yZW1vdmVBdHRyaWJ1dGUoJ2hpZGRlbicpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKHJlc3BvbnNlLnN1Y2Nlc3MpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsZXQgbmV3UGFyZW50ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbmV3UGFyZW50LmlubmVySFRNTCA9IGNvbnRhaW5lci5xdWVyeVNlbGVjdG9yKCdbaW5wdXQtaW1hZ2VzPVwiY2xvbmVcIl0nKS5pbm5lckhUTUw7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsZXQgbmV3RWxlbWVudCA9IG5ld1BhcmVudC5xdWVyeVNlbGVjdG9yKCdbaW5wdXQtaW1hZ2VzPVwiZmlsZVwiXScpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBuZXdJbWFnZSA9IG5ld0VsZW1lbnQucXVlcnlTZWxlY3RvcignaW1nJyksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG5ld0lucHV0ID0gbmV3RWxlbWVudC5xdWVyeVNlbGVjdG9yKCdpbnB1dCcpO1xuXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsZXQgcmVhZGVyID0gbmV3IEZpbGVSZWFkZXIoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZWFkZXIucmVhZEFzRGF0YVVSTChmaWxlKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZWFkZXIub25sb2FkZW5kID0gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBuZXdJbWFnZS5zcmMgPSByZWFkZXIucmVzdWx0O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyBTZXQgZmlsZWxpc3QgZnJvbSBzaW5nbGUgZmlsZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRhdGFUcmFuc2ZlciA9IG5ldyBEYXRhVHJhbnNmZXIoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBkYXRhVHJhbnNmZXIuaXRlbXMuYWRkKGZpbGUpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbmV3SW5wdXQuZmlsZXMgPSBkYXRhVHJhbnNmZXIuZmlsZXM7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbmV3SW5wdXQuc2V0QXR0cmlidXRlKCduYW1lJywgbmV3SW5wdXQuZ2V0QXR0cmlidXRlKCdkYXRhLW5hbWUnKSk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBuZXdFbGVtZW50LnNldEF0dHJpYnV0ZSgnZGF0YS1pbWFnZScsICd0cnVlJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29udGFpbmVyLmluc2VydEJlZm9yZShuZXdFbGVtZW50LCB1cGxvYWQubmV4dFNpYmxpbmcpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9hZEFjdGlvbnMobmV3RWxlbWVudCk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsZXQgZW1wdGllcyA9IGNvbnRhaW5lci5xdWVyeVNlbGVjdG9yQWxsKCdbaW5wdXQtaW1hZ2VzPVwiZW1wdHlcIl06bm90KFtoaWRkZW5dKScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIChlbXB0aWVzLmxlbmd0aCA+IDApIGVtcHRpZXNbMF0uc2V0QXR0cmlidXRlKCdoaWRkZW4nLCAnJyk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBkb2N1bWVudC5kaXNwYXRjaEV2ZW50KG5ldyBDdXN0b21FdmVudCgnb25JbWFnZVVwbG9hZENvbXBsZXRlJywge2RldGFpbDoge2luZGV4OiBpbmRleH19KSk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVycm9yVGV4dC5pbm5lckhUTUwgPSByZXNwb25zZS5tZXNzYWdlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVycm9yLnJlbW92ZUF0dHJpYnV0ZSgnaGlkZGVuJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAodGhpcy5yZWFkeVN0YXRlID09PSA0ICYmIHRoaXMuc3RhdHVzICE9PSAyMDApIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGVycm9yVGV4dC5pbm5lckhUTUwgPSByZXF1ZXN0LnN0YXR1cyArICcgJyArIHJlcXVlc3QubWVzc2FnZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGVycm9yLnJlbW92ZUF0dHJpYnV0ZSgnaGlkZGVuJyk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKHRoaXMucmVhZHlTdGF0ZSA9PT0gMykge1xuICAgICAgICAgICAgICAgICAgICAgICAgbGFiZWwucmVtb3ZlQXR0cmlidXRlKCdoaWRkZW4nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvYWRpbmcuc2V0QXR0cmlidXRlKCdoaWRkZW4nLCAnJyk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgZnVuY3Rpb24gY2hlY2tMaW1pdCgpIHtcbiAgICAgICAgICAgIGxldCBsaW1pdCA9IHBhcnNlSW50KGNvbnRhaW5lci5nZXRBdHRyaWJ1dGUoJ2RhdGEtbGltaXQnKSksXG4gICAgICAgICAgICAgICAgZXhpc3RzID0gY29udGFpbmVyLnF1ZXJ5U2VsZWN0b3JBbGwoJ1tpbnB1dC1pbWFnZXM9XCJmaWxlXCJdW2RhdGEtaW1hZ2U9XCJ0cnVlXCJdJykubGVuZ3RoO1xuXG4gICAgICAgICAgICByZXR1cm4gZXhpc3RzIDwgbGltaXQ7XG4gICAgICAgIH1cblxuICAgICAgICBmdW5jdGlvbiBsb2FkQWN0aW9ucyhuZXdFbGVtZW50KSB7XG4gICAgICAgICAgICBuZXdFbGVtZW50LnF1ZXJ5U2VsZWN0b3JBbGwoJ1tpbnB1dC1pbWFnZXM9XCJmaWxlXCJdW2RhdGEtaW1hZ2U9XCJ0cnVlXCJdIFtpbnB1dC1pbWFnZXM9XCJkZWxldGVcIl0nKS5mb3JFYWNoKGZ1bmN0aW9uIChidXR0b24pIHtcbiAgICAgICAgICAgICAgICBidXR0b24uYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBmdW5jdGlvbiAoZXZlbnQpIHtcbiAgICAgICAgICAgICAgICAgICAgZXZlbnQucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgICAgICAgICAgICAgYnV0dG9uLmNsb3Nlc3QoJ1tpbnB1dC1pbWFnZXM9XCJmaWxlXCJdJykucmVtb3ZlKCk7XG5cbiAgICAgICAgICAgICAgICAgICAgLy8gQ2xlYXIgRmlsZWxpc3RcbiAgICAgICAgICAgICAgICAgICAgZmllbGQudmFsdWUgPSAnJztcblxuICAgICAgICAgICAgICAgICAgICAvLyBTaG93IGVtcHRpZXNcbiAgICAgICAgICAgICAgICAgICAgbGV0IGVtcHRpZXMgPSBjb250YWluZXIucXVlcnlTZWxlY3RvckFsbCgnW2lucHV0LWltYWdlcz1cImVtcHR5XCJdW2hpZGRlbl0nKTtcblxuICAgICAgICAgICAgICAgICAgICBpZiAoZW1wdGllcy5sZW5ndGggPiAwKSBlbXB0aWVzWzBdLnJlbW92ZUF0dHJpYnV0ZSgnaGlkZGVuJyk7XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgIH0pO1xufSk7IiwiLy8gZXh0cmFjdGVkIGJ5IG1pbmktY3NzLWV4dHJhY3QtcGx1Z2luIl0sIm5hbWVzIjpbImRvY3VtZW50IiwiYWRkRXZlbnRMaXN0ZW5lciIsInF1ZXJ5U2VsZWN0b3JBbGwiLCJmb3JFYWNoIiwiY29udGFpbmVyIiwidXBsb2FkIiwicXVlcnlTZWxlY3RvciIsImxhYmVsIiwiZmllbGQiLCJsb2FkaW5nIiwiZXJyb3IiLCJlcnJvclRleHQiLCJwcmV2ZW50RGVmYXVsdHMiLCJoaWdobGlnaHRVcGxvYWQiLCJ1bkhpZ2hsaWdodFVwbG9hZCIsImVsZW1lbnQiLCJmaWxlcyIsImRhdGFUcmFuc2ZlciIsImFkZEltYWdlIiwiZXZlbnQiLCJpbmRleCIsImRldGFpbCIsImxlbmd0aCIsInRhcmdldCIsImUiLCJwcmV2ZW50RGVmYXVsdCIsInN0b3BQcm9wYWdhdGlvbiIsImNsYXNzTGlzdCIsImFkZCIsInJlbW92ZSIsImZpbGUiLCJjaGVja0xpbWl0Iiwic2V0QXR0cmlidXRlIiwicmVtb3ZlQXR0cmlidXRlIiwicmVxdWVzdCIsIlhNTEh0dHBSZXF1ZXN0IiwicmVxdWVzdFVybCIsImNsb3Nlc3QiLCJnZXRBdHRyaWJ1dGUiLCJmb3JtRGF0YSIsIkZvcm1EYXRhIiwic2V0IiwiYXBwZW5kIiwib3BlbiIsInNlbmQiLCJvbnJlYWR5c3RhdGVjaGFuZ2UiLCJyZWFkeVN0YXRlIiwic3RhdHVzIiwicmVzcG9uc2UiLCJKU09OIiwicGFyc2UiLCJpbm5lckhUTUwiLCJtZXNzYWdlIiwic3VjY2VzcyIsIm5ld1BhcmVudCIsImNyZWF0ZUVsZW1lbnQiLCJuZXdFbGVtZW50IiwibmV3SW1hZ2UiLCJuZXdJbnB1dCIsInJlYWRlciIsIkZpbGVSZWFkZXIiLCJyZWFkQXNEYXRhVVJMIiwib25sb2FkZW5kIiwic3JjIiwicmVzdWx0IiwiRGF0YVRyYW5zZmVyIiwiaXRlbXMiLCJpbnNlcnRCZWZvcmUiLCJuZXh0U2libGluZyIsImxvYWRBY3Rpb25zIiwiZW1wdGllcyIsImRpc3BhdGNoRXZlbnQiLCJDdXN0b21FdmVudCIsImxpbWl0IiwicGFyc2VJbnQiLCJleGlzdHMiLCJidXR0b24iLCJ2YWx1ZSJdLCJzb3VyY2VSb290IjoiIn0=