/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!************************************************!*\
  !*** ./com_radicalreviews/es6/field/media.es6 ***!
  \************************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('[radicalreviews-media="container"]').forEach(function (container) {
    var upload = container.querySelector('[radicalreviews-media="upload"]'),
      label = upload.querySelector('label'),
      field = upload.querySelector('input'),
      loading = upload.querySelector('.loading'),
      error = container.querySelector('[radicalreviews-media="error"]'),
      errorText = error.querySelector('.error-text');
    label.addEventListener('dragenter', preventDefaults, false);
    label.addEventListener('dragover', preventDefaults, false);
    label.addEventListener('dragleave', preventDefaults, false);
    label.addEventListener('drop', preventDefaults, false);
    label.addEventListener('dragenter', highlightUpload, false);
    label.addEventListener('dragover', highlightUpload, false);
    label.addEventListener('dragleave', unHighlightUpload, false);
    label.addEventListener('drop', unHighlightUpload, false);

    // Drop event
    label.addEventListener('drop', function (element) {
      var files = element.dataTransfer.files;
      addMedia(files, 0);
    });

    // Change event
    field.addEventListener('change', function (element) {
      preventDefaults(element);
      var files = element.target.files;
      addMedia(files, 0);
    });

    // Upload complete event
    document.addEventListener('onMediaUploadComplete', function (event) {
      var index = event.detail.index + 1,
        files = event.detail.files;
      console.info('index - ' + index);
      console.info('length - ' + files.length);
      if (index === files.length) {
        return;
      }
      addMedia(files, index);
    });

    // Stop function
    function preventDefaults(e) {
      e.preventDefault();
      e.stopPropagation();
    }

    // Set highlight
    function highlightUpload() {
      label.classList.add('dragend');
    }

    // Unset highlight
    function unHighlightUpload() {
      label.classList.remove('dragend');
    }
    function addMedia(files, index) {
      var file = files[index];
      if (checkLimit() && file) {
        error.setAttribute('hidden', '');
        label.setAttribute('hidden', '');
        loading.removeAttribute('hidden');
        var request = new XMLHttpRequest(),
          requestUrl = container.closest('form').getAttribute('action'),
          formData = new FormData();
        formData.set('task', 'review.checkMedia');
        formData.append('media[]', file);
        request.open('POST', requestUrl);
        request.send(formData);
        request.onreadystatechange = function () {
          if (this.readyState === 4 && this.status === 200) {
            var response = false;
            try {
              response = JSON.parse(this.response);
            } catch (e) {
              response = false;
              errorText.innerHTML = e.message;
              error.removeAttribute('hidden');
              return;
            }
            if (response.success) {
              var mediaType = response.data,
                newParent = document.createElement('div');
              newParent.innerHTML = container.querySelector('[radicalreviews-media="clone"]').innerHTML;
              var newElement = newParent.querySelector('[radicalreviews-media="file"]'),
                newInput = newElement.querySelector('input');
              if (mediaType === 'image') {
                newMedia = newElement.querySelector('img');
                newElement.querySelector('video').remove();
              } else {
                newMedia = newElement.querySelector('video');
                newElement.querySelector('img').remove();
              }
              var reader = new FileReader();
              reader.readAsDataURL(file);
              reader.onloadend = function () {
                newMedia.src = reader.result;
              };

              // Set filelist from single file
              dataTransfer = new DataTransfer();
              dataTransfer.items.add(file);
              newInput.files = dataTransfer.files;
              newInput.setAttribute('name', newInput.getAttribute('data-name'));
              newElement.setAttribute('data-media', 'true');
              container.insertBefore(newElement, upload.nextSibling);
              loadActions(newElement);
              var empties = container.querySelectorAll('[radicalreviews-media="empty"]:not([hidden])');
              if (empties.length > 0) empties[0].setAttribute('hidden', '');
              document.dispatchEvent(new CustomEvent('onMediaUploadComplete', {
                detail: {
                  index: index,
                  files: files
                }
              }));
            } else {
              errorText.innerHTML = response.message;
              error.removeAttribute('hidden');
            }
          } else if (this.readyState === 4 && this.status !== 200) {
            errorText.innerHTML = request.status + ' ' + request.message;
            error.removeAttribute('hidden');
          }
          if (this.readyState === 3) {
            label.removeAttribute('hidden');
            loading.setAttribute('hidden', '');
          }
        };
      }
    }
    function checkLimit() {
      var limit = parseInt(container.getAttribute('data-limit')),
        exists = container.querySelectorAll('[radicalreviews-media="file"][data-media="true"]').length;
      return exists < limit;
    }
    function loadActions(newElement) {
      newElement.querySelectorAll('[radicalreviews-media="file"][data-media="true"] [radicalreviews-media="delete"]').forEach(function (button) {
        button.addEventListener('click', function (event) {
          event.preventDefault();
          button.closest('[radicalreviews-media="file"]').remove();

          // Clear Filelist
          field.value = null;

          // Show empties
          var empties = container.querySelectorAll('[radicalreviews-media="empty"][hidden]');
          if (empties.length > 0) empties[0].removeAttribute('hidden');
        });
      });
    }
  });
});
})();

// This entry need to be wrapped in an IIFE because it need to be isolated against other entry modules.
(() => {
/*!**************************************************!*\
  !*** ./com_radicalreviews/scss/field/media.scss ***!
  \**************************************************/
// extracted by mini-css-extract-plugin
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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