/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

/******/ (() => { // webpackBootstrap
/******/ 	/************************************************************************/
var __webpack_exports__ = {};
/*!*************************************************!*\
  !*** ./com_radicalreviews/es6/field/rating.es6 ***!
  \*************************************************/
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

document.addEventListener('DOMContentLoaded', function () {
  document.querySelectorAll('[input-rating="container"]').forEach(function (container) {
    // let local = 'rating_vote_' + container.getAttribute('data-context') + '_' + container.getAttribute('data-item_id');
    var voted = parseInt(container.getAttribute('data-voted'));
    console.info(voted);
    container.querySelectorAll('[radicalreviews-rating="star"]').forEach(function (star) {
      if (!voted) {
        if (star.getAttribute('data-active') === 'true') {
          star.addEventListener('click', function (event) {
            event.preventDefault();
            setChecked(star.getAttribute('data-value'));
            container.querySelector('[input-rating="field"]').value = star.getAttribute('data-value');
          });
          star.addEventListener('mouseover', function () {
            setChecked(star.getAttribute('data-value'));
          });
          star.addEventListener('mouseout', function () {
            setChecked(container.querySelector('[input-rating="field"]').value);
          });
        }
      } else {
        setChecked(voted);
      }
    });
    function setChecked(value) {
      value = parseInt(value);
      container.querySelectorAll('[radicalreviews-rating="star"]').forEach(function (star) {
        if (parseInt(star.getAttribute('data-value')) <= value) {
          star.setAttribute('data-checked', 'true');
        } else {
          star.setAttribute('data-checked', 'false');
        }
      });
    }
  });
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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