<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Plugin\RadicalReviews\Content\Helper;

defined('_JEXEC') or die;

use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\Input\Input;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;

/**
 * @package     Helper class
 *
 * @since       1.0.0
 */
class ContentHelper
{
	/**
	 * @var Registry
	 *
	 * @since 1.0.0
	 */
	protected $params;

	/**
	 * @var Input
	 *
	 * @since 1.0.0
	 */
	protected $input;

	/**
	 * @var Object
	 *
	 * @since 1.0.0
	 */
	protected $_object;

	/**
	 * @var array
	 *
	 * @since 0.0.0
	 */
	protected static $_contexts = [
		'com_content.article'    => 'Article'
	];


	/**
	 * @param   Registry  $params
	 *
	 * @since 1.0.0
	 */
	public function __construct(Registry $params)
	{
		$this->params = $params;
		$this->input  = Factory::getApplication()->input;
	}

	/**
	 * Get items
	 *
	 * @since 1.0.0
	 */
	public static function getObject($item_id = null, $context = 'com_content.article')
	{
		$item = '';

		// Check context
		if (!isset(self::$_contexts[$context]))
		{
			return $item;
		}

		// Get app
		$app = Factory::getApplication();

		// Get model
		$model = $app->bootComponent('com_content')->getMVCFactory()->createModel('Article', 'Site', ['ignore_request' => true]);

		// Set application parameters in model
		$model->setState('params', new Registry());

		try
		{
			$item = $model->getItem($item_id);

			$item->slug   = $item->id . ':' . $item->alias;
			$item->images = new Registry($item->images);

			// Get link
			$item->link = RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language);

			// Get image
			$item->image = $item->images->get('image_fulltext', $item->images->get('image_intro'));
		}
		catch (\Exception $e)
		{
            // Noop
		}

		return $item;
	}
}