<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Filesystem\Path;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Response\JsonResponse;
use Joomla\Component\RadicalReviews\Administrator\Helper\MediaHelper;
use Joomla\Filesystem\File;

class ReviewController extends FormController
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var  string
	 *
	 * @since  1.0.0
	 */
	protected $text_prefix = 'COM_RADICALREVIEWS_REVIEW';

	/**
	 * Proxy for getModel.
	 *
	 * @param   string  $name    The model name.
	 * @param   string  $prefix  The class prefix.
	 * @param   array   $config  The array of possible config values.
	 *
	 * @return  BaseDatabaseModel A model object.
	 *
	 * @since  1.0.0
	 */
	public function getModel($name = 'Review', $prefix = 'Administrator', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	/**
	 * Method to validate media.
	 *
	 * @return boolean True on success, False on failure.
	 *
	 * @throws \Exception
	 *
	 * @since  1.0.0
	 */
	public function checkMedia()
	{
		$medias = $this->input->files->get('media', array(), 'array');
		$media  = (!empty($medias[0])) ? $medias[0] : false;

		// Check media
		$result  = false;
		$message = Text::_('COM_RADICALREVIEWS_ERROR_MEDIA_NOT_FOUND');

		if ($media)
		{
			$message = MediaHelper::getInstance()->checkError($media);

			if (!$message)
			{
				$message = ($result = MediaHelper::getInstance()->checkMedia($media['tmp_name'])) ? ''
				: Text::_('COM_RADICALREVIEWS_ERROR_MEDIA_FORMAT');
			}
		}

		header('Content-Type: application/json');
		echo new JsonResponse($result, $message, (!$result));
		Factory::getApplication()->close(($result) ? 200 : 404);

		return $result;
	}

	/**
	 * Method to save a record.
	 *
	 * @param   string  $key     The name of the primary key of the URL variable.
	 * @param   string  $urlVar  The name of the URL variable if different from the primary key (sometimes required to avoid router collisions).
	 *
	 * @return  boolean  True if successful, false otherwise.
	 *
	 * @throws  \Exception
	 *
	 * @since   1.1.0
	 */
	public function save($key = null, $urlVar = null)
	{
		$data  = $this->input->post->get('jform', array(), 'array');
		$files = $this->input->files->get('jform', array(), 'array');

		if (!empty($files['media']))
		{
			$data['media'] = $files['media'];

			$this->input->post->set('jform', $data);
		}

		parent::save($key, $urlVar);
	}

	/**
	 * Method to delete image.
	 *
	 * @return boolean True on success, False on failure.
	 *
	 * @throws \Exception
	 *
	 * @since  1.1.0
	 */
	public function deleteMedia()
	{
		$media = $this->input->getString('path');

		if ($media)
		{
			$path   = Path::clean(JPATH_ROOT . '/' . $media);
			$result = File::delete($path);

			$parsePath = pathinfo($path);
			$files     = Folder::files($parsePath['dirname']);
			$message   = '';

			if (!$files)
			{
				Folder::delete($parsePath['dirname']);
			}
		}
		else
		{
			$result  = false;
			$message = Text::_('COM_RADICALREVIEWS_ERROR_MEDIA_NOT_FOUND');
		}

		header('Content-Type: application/json');
		echo new JsonResponse($result, $message, (!$result));
		Factory::getApplication()->close(($result) ? 200 : 404);

		return $result;
	}
}