<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Component\RadicalReviews\Administrator\Helper\EventHelper;
use Joomla\Component\RadicalReviews\Administrator\Helper\ReviewsHelper;

class ContextField extends ListField
{
	/**
	 * The form field type.
	 *
	 * @var  string
	 *
	 * @since  1.1.0
	 */
	protected $type = 'context';

	/**
	 * The path to folder for plugins.
	 *
	 * @var    string
	 * @since  1.1.0
	 */
	protected $folder = 'radicalreviews';

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.1.0
	 */
	protected function getOptions()
	{
		$this->loadLanguages();

		$parentOptions = parent::getOptions();

		$options  = [];
		$contexts = EventHelper::getContexts($this);


		if ($contexts)
		{
			foreach ($contexts as $key => $context)
			{
				$tmp        = new \stdClass();
				$tmp->text  = ReviewsHelper::getContextTitle($key);
				$tmp->value = $key;

				$options[$key] = $tmp;
			}
		}

		return array_merge($parentOptions, $options);
	}

	/**
	 * Method for load plugins languages
	 *
	 * @throws \Exception
	 *
	 * @since 1.1.0
	 */
	protected function loadLanguages()
	{
		if (!empty($this->folder))
		{
			// Get list of plugins
			$db    = $this->getDatabase();
			$app   = Factory::getApplication();
			$query = $db->getQuery(true)
				->select(
					[
						$db->quoteName('element', 'value'),
						$db->quoteName('name', 'text'),
					]
				)
				->from($db->quoteName('#__extensions'))
				->where(
					[
						$db->quoteName('folder') . ' = :folder',
						$db->quoteName('enabled') . ' = 1',
					]
				)
				->bind(':folder', $this->folder)
				->order(
					[
						$db->quoteName('ordering'),
						$db->quoteName('name'),
					]
				);

			$plugins = $db->setQuery($query)->loadObjectList();
			$lang    = $app->getLanguage();

			foreach ($plugins as $i => $plugin)
			{
				$source    = JPATH_PLUGINS . '/' . $this->folder . '/' . $plugin->value;
				$extension = 'plg_' . $this->folder . '_' . $plugin->value;
				$lang->load($extension . '.sys', JPATH_ADMINISTRATOR) || $lang->load($extension . '.sys', $source);
			}
		}
	}
}