<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Event\AbstractEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;

class EventHelper
{
	/**
	 * Has the extension association support
	 *
	 * @var     array
	 *
	 * @since   1.0.0
	 */
	protected static $contexts = [];

	/**
	 * @var array
	 *
	 * @since 1.0.0
	 */
	public static $events = [
		'getObject'   => 'onRadicalReviewsGetObject',
		'getContexts' => 'onRadicalReviewsGetContexts',
		'afterSave'   => 'onRadicalReviewsAfterSave'
	];

	/**
	 * Fetches add rating route.
	 *
	 * @param   object  $subject  Event subject.
	 * @param   int     $item_id  Object id.
	 * @param   string  $context  Object context.
	 * @param   bool    $checkStop
	 *
	 * @return  object  Add rating controller link.
	 *
	 * @since  1.0.0
	 */
	public static function getObject($subject, $item_id = null, $context = null)
	{

		// Prepare object
		$object = new \stdClass();

		if (!$item_id || !$context)
		{
			return $object;
		}

		// Process the Radical Reviews plugins
		PluginHelper::importPlugin('radicalreviews');

		// Trigger event
		$result = Factory::getApplication()->getDispatcher()->dispatch(
			self::$events[__FUNCTION__],
			AbstractEvent::create(
				self::$events[__FUNCTION__],
				[
					'subject' => $subject,
					'context' => $context,
					'item_id' => $item_id
				]
			)
		);

		$object = $result->getArgument('result');

		if ($object)
		{
			$object->title     = $object->title ?? ($object->name ?? Text::_('COM_RADICALREVIEWS_ERROR_OBJECT_NOT_FOUND'));
			$object->link      = $object->link ?? '';
			$object->image     = $object->image ?? '';
			$object->context   = $context;
			$object->state     = $object->state ?? $object->published ?? 0;
			$object->addReview = RouteHelper::getFormRoute($item_id, $context);
		}

		return $object;
	}

	/**
	 * Fetches add rating route.
	 *
	 * @param   object     $subject  Event subject.
	 * @param   \stdClass  $review   Review object.
	 * @param   array      $data     Review data.
	 *
	 * @return  object  Add rating controller link.
	 *
	 * @since  1.0.0
	 */
	public static function afterSave($subject, $review = null, $data = null)
	{
		// Process the Radical Reviews plugins
		PluginHelper::importPlugin('radicalreviews');

		// Trigger event
		$result = Factory::getApplication()->getDispatcher()->dispatch(
			self::$events[__FUNCTION__],
			AbstractEvent::create(
				self::$events[__FUNCTION__],
				[
					'subject' => $subject,
					'review'  => $review,
					'data'    => $data
				]
			)
		);

		return $result;
	}

	/**
	 * Fetches add rating route.
	 *
	 * @param   object     $subject  Event subject.
	 * @param   \stdClass  $review   Review object.
	 * @param   array      $data     Review data.
	 *
	 * @return  array  Add rating controller link.
	 *
	 * @since  1.0.0
	 */
	public static function getContexts($subject)
	{
		if (!self::$contexts)
		{
			// Process the Radical Reviews plugins
			PluginHelper::importPlugin('radicalreviews');

			// Trigger event
			$event = Factory::getApplication()->getDispatcher()->dispatch(
				self::$events[__FUNCTION__],
				AbstractEvent::create(
					self::$events[__FUNCTION__],
					[
						'subject' => $subject
					]
				)
			);

			$contexts = $event->getArgument('result');

			self::$contexts = array_merge(...$contexts);
		}

		return self::$contexts;
	}
}