<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

class ReviewsHelper extends ContentHelper
{

	/**
	 * @param   string  $type  Type of plugin.
	 *
	 * @throws \Exception
	 *
	 * @since 1.0.0
	 */
	public static function loadPluginsLanguages($type = 'radicalreviews')
	{
		// Get list of plugins
		$db    = Factory::getContainer()->get('DatabaseDriver');
		$app   = Factory::getApplication();
		$query = $db->getQuery(true)
			->select(
				[
					$db->quoteName('element', 'value'),
				]
			)
			->from($db->quoteName('#__extensions'))
			->where(
				[
					$db->quoteName('folder') . ' = ' . $db->quote($type),
					$db->quoteName('enabled') . ' = 1',
				]
			);

		$plugins = $db->setQuery($query)->loadObjectList();
		$lang    = $app->getLanguage();

		foreach ($plugins as $plugin)
		{
			$pluginName = 'plg_' . $type . '_' . $plugin->value;
			$lang->load($pluginName, JPATH_SITE);
		}
	}


	/**
	 * Method for get context title.
	 *
	 * @param string $context
	 *
	 * @since 1.0.0
	 */
	public static function getContextTitle($context)
	{
		$context = strtoupper(str_replace('.', '_', $context));

		return Text::_('COM_RADICALREVIEWS_CONTEXT_TITLE_' . $context);
	}
}
