<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Administrator\Traits;

\defined('_JEXEC') or die;

use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalReviews\Administrator\Helper\EventHelper;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;
use Joomla\Registry\Registry;
use Joomla\Utilities\ArrayHelper;

trait AdminModelTrait
{
	/**
	 * Objects array.
	 *
	 * @var  array|null
	 *
	 * @since  1.0.0
	 */
	protected static ?array $item = null;

	/**
	 * Method to get object data.
	 *
	 * @param   integer  $item_id  The id of the object.
	 * @param   string   $context   The context.
	 *
	 * @return  object|boolean|\Exception  Object on success, false or exception on failure.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function getObject($item_id = null, $context = null)
	{
		$item_id = (!empty($item_id)) ? $item_id : (int) $this->getState('object.item_id');
		$context  = (!empty($context)) ? $context : $this->getState('object.context');

		if (self::$item === null)
		{
			self::$item = array();
		}

		if (!isset(self::$item[$context . '_' . $item_id]))
		{
			// Prepare object
			$object = EventHelper::getObject($this, $item_id, $context);

			if ($object)
			{
				$object->link  = $object->link ?? '';
				$object->title = $object->title ?? '';
			}

			self::$item[$context . '_' . $item_id] = $object;
		}

		return self::$item[$context . '_' . $item_id];
	}
}