<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;

$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalreviews');
$assets->usePreset('com_radicalreviews.site.field.media');

extract($displayData);

/**
 * Layout variables
 * -----------------
 * @var   string  $autocomplete   Autocomplete attribute for the field.
 * @var   boolean $autofocus      Is autofocus enabled?
 * @var   string  $class          Classes for the input.
 * @var   string  $description    Description of the field.
 * @var   boolean $disabled       Is this field disabled?
 * @var   string  $group          Group the field belongs to. <fields> section in form XML.
 * @var   boolean $hidden         Is this field hidden in the form?
 * @var   string  $hint           Placeholder for the field.
 * @var   string  $id             DOM id of the field.
 * @var   string  $label          Label of the field.
 * @var   string  $labelclass     Classes to apply to the label.
 * @var   boolean $multiple       Does this field support multiple values?
 * @var   string  $name           Name of the input field.
 * @var   string  $onchange       Onchange attribute for the field.
 * @var   string  $onclick        Onclick attribute for the field.
 * @var   string  $pattern        Pattern (Reg Ex) of value of the form field.
 * @var   boolean $readonly       Is this field read only?
 * @var   boolean $repeat         Allows extensions to duplicate elements.
 * @var   boolean $required       Is this field required?
 * @var   integer $size           Size attribute of the input.
 * @var   boolean $spellcheck     Spellcheck state for the form field.
 * @var   string  $validate       Validation rules to apply.
 * @var   array   $value          Value attribute of the field.
 * @var   array   $checkedOptions Options that will be set as checked.
 * @var   boolean $hasValue       Has this field a value assigned?
 * @var   array   $options        Options available for this field.
 * @var   array   $inputType      Options available for this field.
 * @var   string  $accept         File types that are accepted.
 * @var   string  $dataAttribute  Miscellaneous data attributes preprocessed for HTML output
 * @var   array   $dataAttributes Miscellaneous data attribute for eg, data-*.
 * @var   string  $dirname        The directory name
 * @var   string  $addonBefore    The text to use in a bootstrap input group prepend
 * @var   string  $addonAfter     The text to use in a bootstrap input group append
 */

$componentParams = ComponentHelper::getParams('com_radicalreviews');
$limit           = $componentParams->get('media_count', $componentParams->get('images_count', 3));

?>
<div radicalreviews-media="container" class="uk-child-width-auto uk-grid-small" uk-grid="" data-limit="<?php echo $limit; ?>">
    <div class="uk-width-1-1" radicalreviews-media="error" hidden>
        <div class="uk-alert uk-alert-danger error-text"></div>
    </div>
    <div radicalreviews-media="upload">
        <label for="<?php echo $id . '_upload'; ?>" class="image-block uk-flex-center uk-flex-middle">
            <span uk-icon="icon:plus; ratio: 1.5"></span>
            <input id="<?php echo $id . '_upload'; ?>" type="file" accept="image/*, video/*" multiple>
        </label>
        <div class="image-block uk-flex-center uk-flex-middle loading" hidden>
            <span uk-spinner></span>
        </div>
    </div>
	<?php for ($i = 1; $i <= $limit; $i++): ?>
        <div radicalreviews-media="empty">
            <div class="image-block"></div>
        </div>
	<?php endfor; ?>
    <div radicalreviews-media="clone" hidden>
        <div radicalreviews-media="file">
            <div class="image-block uk-cover-container">
				<span class="uk-link uk-position-top-right uk-text-danger uk-position-z-index"
                      uk-icon="icon:close;" radicalreviews-media="delete"></span>
                <img src="#" uk-cover no-lazy>
                <video src="#" uk-cover no-lazy></video>
                <input type="file" data-name="<?php echo $name . '[]'; ?>" accept="image/*, video/*">
            </div>
        </div>
    </div>
</div>