<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var int    $item_id    Asset id.
 * @var string $context    Context.
 * @var string $addReview  Add reviews link.
 * @var string $allReviews All reviews link.
 * @var array  $reviews    Reviews array.
 * @var int    $total      Total of reviews.
 * @var int    $reviewed   Is object reviewed.
 *
 */

$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalreviews');
$assets->useStyle('com_radicalreviews.site.stars');

Factory::getApplication()->getLanguage()->load('com_radicalreviews', JPATH_SITE);

?>
<div id="radicalreviews" class="reviews">
    <?php if (!$reviewed) : ?>
        <div class="uk-margin">
            <a href="<?php echo $addReview; ?>" class="uk-button uk-button-primary">
                <?php echo Text::_('COM_RADICALREVIEWS_REVIEWS_ADD'); ?>
            </a>
        </div>
    <?php endif; ?>

	<?php if ($reviews) : ?>
        <ul class="uk-list">
			<?php foreach ($reviews as $review) : ?>
                <li>
					<?php echo LayoutHelper::render('components.radicalreviews.reviews.item.review', ['item' => $review]); ?>
                </li>
			<?php endforeach; ?>
        </ul>

		<?php
		$count = count($reviews);

		if ($count < $total) : ?>
            <div class="uk-margin uk-text-center">
                <a href="<?php echo $allReviews; ?>" class="uk-button uk-button-primary">
					<?php echo Text::_('COM_RADICALREVIEWS_REVIEWS_ALL'); ?>
                </a>
            </div>
		<?php endif; ?>
	<?php else : ?>
        <div class="uk-alert uk-alert-info"><?php echo Text::_('COM_RADICALREVIEWS_REVIEWS_EMPTY'); ?></div>
	<?php endif; ?>
</div>