<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  int    $item_id   Asset id.
 * @var  string $context   Context.
 * @var  int    $stars     Total stars.
 * @var  int    $votes     Total votes.
 * @var  int    $rating    Calculate rating.
 * @var  int    $reviews   Reviews count.
 * @var  string $link      Reviews link.
 * @var  string $add       Add review link.
 * @var  string $addRating Add rating controller link.
 * @var  bool   $voted     Is object voted by current user.
 * @var  bool   $reviewed  Is object reviewed by current user.
 */

// Load assets
$app    = Factory::getApplication();
$assets = $app->getDocument()->getWebAssetManager();
$assets->getRegistry()->addExtensionRegistryFile('com_radicalreviews');
$assets->usePreset('com_radicalreviews.site.stats');

$app->getLanguage()->load('com_radicalreviews', JPATH_SITE);

?>
<div class="uk-child-width-auto@s uk-grid-small uk-grid-divider uk-flex-middle uk-margin-small-bottom" uk-grid="">
    <div radicalreviews-rating="container"
         data-active="true"
         data-voted="<?php echo $voted; ?>"
         data-value="<?php echo $rating; ?>"
         data-controller="<?php echo $addRating; ?>"
         data-item_id="<?php echo $item_id; ?>"
         data-context="<?php echo $context; ?>"
         data-error="<?php echo Text::_('COM_RADICALREVIEWS_ERROR_RATING_VOTE'); ?>">
        <div class="uk-flex uk-flex-middle">
			<span class="uk-text-muted uk-margin-small-right">
				<?php echo Text::_('COM_RADICALREVIEWS_RATING_COUNT') . ':'; ?>
			</span>
			<?php for ($i = 1; $i <= 5; $i++): ?>
                <span radicalreviews-rating="star" data-value="<?php echo $i; ?>" data-active="true"
                      class="uk-h2 uk-margin-remove"
                      data-checked="<?php echo ($i <= $rating) ? 'true' : 'false'; ?>"></span>
			<?php endfor; ?>
			<?php if ($rating): ?>
                <span class="uk-margin-remove uk-text-muted">(<?php echo $rating; ?>)</span>
			<?php endif; ?>
        </div>
        <div radicalreviews-rating="modal" uk-modal>
            <div class="uk-modal-dialog uk-modal-body uk-text-center">
                <button class="uk-modal-close-default" type="button" uk-close></button>
                <div class="uk-flex uk-flex-middle uk-flex-center">
                    <div class="uk-text-large uk-margin-small-right">
						<?php echo Text::_('COM_RADICALREVIEWS_RATING_ADD_SUCCESS_TITLE'); ?>:
                    </div>
					<?php for ($i = 1; $i <= 5; $i++): ?>
                        <span radicalreviews-rating="star" data-value="<?php echo $i; ?>" data-active="false"
                              class="uk-h2 uk-margin-remove"
                              data-checked="<?php echo ($i <= $rating) ? 'true' : 'false'; ?>"></span>
					<?php endfor; ?>
                    <span class="uk-margin-remove uk-text-muted">(5)</span>
                </div>
                <p class="uk-text-large">
					<?php echo Text::_('COM_RADICALREVIEWS_RATING_ADD_SUCCESS_MESSAGE'); ?>
                </p>
                <div>
                    <a href="<?php echo $add; ?>" class="uk-button uk-button-primary">
						<?php echo Text::_('COM_RADICALREVIEWS_RATING_ADD_SUCCESS_BUTTON'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div radicalreviews-rating="add" data-reviewed="<?php echo $reviewed; ?>"
         data-link-attributes='<?php echo json_encode(array(
		     'href'                  => $add,
		     'radicalreviews-rating' => 'form',
		     'class'                 => 'uk-text-muted uk-text-lowercase',
		     'innerText'             => '[' . Text::_('COM_RADICALREVIEWS_REVIEWS_COUNT_ADD') . ']',
		     'rel'                   => 'nofollow'
	     )); ?>'>
		<?php if ($reviews): ?>
            <a href="<?php echo $link; ?>" class="uk-text-muted">
				<?php echo Text::_('COM_RADICALREVIEWS_REVIEWS_COUNT') . ': ' . $reviews . ' '; ?>
            </a>
		<?php else: ?>
            <span class="uk-text-muted">
				<?php echo Text::_('COM_RADICALREVIEWS_REVIEWS_COUNT') . ': ' . $reviews . ' '; ?>
			</span>
		<?php endif; ?>
    </div>
</div>