<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

namespace Joomla\Component\RadicalReviews\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Router\Route;
use Joomla\Component\RadicalReviews\Administrator\Model\ReviewModel;
use Joomla\Component\RadicalReviews\Site\Helper\ReviewsHelper;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;

class FormModel extends ReviewModel
{
	/**
	 * Model context string.
	 *
	 * @var  string
	 *
	 * @since  1.0.0
	 */
	protected $_context = 'com_radicalreviews.form';

	/**
	 * View link.
	 *
	 * @var  string
	 *
	 * @since  1.0.0
	 */
	protected $_link = null;

	/**
	 * Method to auto-populate the model state.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	protected function populateState()
	{
		/* @var SiteApplication $app */
		$app  = Factory::getApplication('site');
		$item = ReviewsHelper::parseItem($app->input->getString('item'));

		// Set request states
		$this->setState('object.item_id', $item->item_id);
		$this->setState('object.context', $item->context);

		// Set params state
		$params = $app->getParams();
		$this->setState('params', $params);

		parent::populateState();

		// Hack for no sef form
		$this->setState($this->getName() . '.id', 0);
	}

	/**
	 * Abstract method for getting the form from the model.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  Form|boolean  A Form object on success, false on failure.
	 *
	 * @throws  \Exception
	 *
	 * @since  1.0.0
	 */
	public function getForm($data = array(), $loadData = true)
	{
		if ($form = parent::getForm($data, $loadData))
		{
			$user = Factory::getApplication()->getIdentity();

			$form->setValue('email', '', $this->getState('name', $user->email));
			$form->setValue('name', '', $this->getState('email', $user->name));
			$form->setValue('item_id', '', $this->getState('object.item_id', 0));
			$form->setValue('context', '', $this->getState('object.context', ''));
			$form->setValue('ip','', Factory::getApplication()->input->server->get('REMOTE_ADDR'));
		}

		return $form;
	}

	/**
	 * Method to get view link by primary key.
	 *
	 * @param   int     $pk    The id of the primary key.
	 * @param   string  $view  The view name.
	 *
	 * @return false|string View link on success, False on failure.
	 *
	 * @throws \Exception
	 *
	 * @since  1.0.0
	 */
	public function getLink($item_id = null, $context = null, $view = null)
	{
		if (empty($item_id) || empty($view) || empty($context)) return false;

		if ($this->_link === null)
		{
			$this->_link = array();
		}

		$hash = md5($view . '_' . $context . '_' . $item_id);

		if (!isset($this->_link[$hash]))
		{
			$link = false;
			if ($view === 'review')
			{
				$link = RouteHelper::getReviewRoute($item_id, $context);
			}
			elseif ($view === 'reviews')
			{
				$link = RouteHelper::getReviewsRoute($item_id, $context);
			}
			elseif ($view === 'form')
			{
				$link = RouteHelper::getFormRoute($item_id, $context);
			}

			$this->_link[$hash] = ($link) ? Route::_($link, true) : false;
		}

		return $this->_link[$hash];
	}
}