<?php
/*
 * @package   pkg_radicalreviews
 * @version   1.1.0
 * @author    Delo Design
 * @copyright Copyright (c) 2023 Delo Design. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://delo-design.ru
 */

use Joomla\CMS\HTML\Helpers\StringHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\RadicalReviews\Site\Helper\RouteHelper;

defined('_JEXEC') or die;

extract($displayData);

/**
 * Layout variables
 * -----------------
 *
 * @var  string $header Header value.
 * @var  object $item   Review item object.
 * @var  array  $footer Array of footer values.
 *
 */

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><!--[if gte mso 15]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml>
    <![endif]-->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo $subject ?></title></head>
<body style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;background-color:#FAFAFA;height:100%;margin:0;padding:0;width:100%">
<style type="text/css">@media only screen and (min-width: 768px) {
        .templateContainer {
            width: 600px !important
        }
    }

    @media only screen and (max-width: 480px) {
        a, blockquote, body, li, p, table, td {
            -webkit-text-size-adjust: none !important
        }
    }

    @media only screen and (max-width: 480px) {
        body {
            width: 100% !important;
            min-width: 100% !important
        }
    }

    @media only screen and (max-width: 480px) {
        #bodyCell {
            padding-top: 10px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnRetinaImage {
            max-width: 100% !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnImage {
            width: 100% !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnBoxedTextContentContainer, .mcnCaptionBottomContent, .mcnCaptionLeftImageContentContainer, .mcnCaptionLeftTextContentContainer, .mcnCaptionRightImageContentContainer, .mcnCaptionRightTextContentContainer, .mcnCaptionTopContent, .mcnCartContainer, .mcnImageCardLeftImageContentContainer, .mcnImageCardLeftTextContentContainer, .mcnImageCardRightImageContentContainer, .mcnImageCardRightTextContentContainer, .mcnImageGroupContentContainer, .mcnRecContentContainer, .mcnTextContentContainer {
            max-width: 100% !important;
            width: 100% !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnBoxedTextContentContainer {
            min-width: 100% !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnImageGroupContent {
            padding: 9px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnCaptionLeftContentOuter .mcnTextContent, .mcnCaptionRightContentOuter .mcnTextContent {
            padding-top: 9px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnCaptionBlockInner .mcnCaptionTopContent:last-child .mcnTextContent, .mcnCaptionBottomContent:last-child .mcnCaptionBottomImageContent, .mcnImageCardTopImageContent {
            padding-top: 18px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnImageCardBottomImageContent {
            padding-bottom: 9px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnImageGroupBlockInner {
            padding-top: 0 !important;
            padding-bottom: 0 !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnImageGroupBlockOuter {
            padding-top: 9px !important;
            padding-bottom: 9px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnBoxedTextContentColumn, .mcnTextContent {
            padding-right: 18px !important;
            padding-left: 18px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnImageCardLeftImageContent, .mcnImageCardRightImageContent {
            padding-right: 18px !important;
            padding-bottom: 0 !important;
            padding-left: 18px !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcpreview-image-uploader {
            display: none !important;
            width: 100% !important
        }
    }

    @media only screen and (max-width: 480px) {
        h1 {
            font-size: 22px !important;
            line-height: 125% !important
        }
    }

    @media only screen and (max-width: 480px) {
        h2 {
            font-size: 20px !important;
            line-height: 125% !important
        }
    }

    @media only screen and (max-width: 480px) {
        h3 {
            font-size: 18px !important;
            line-height: 125% !important
        }
    }

    @media only screen and (max-width: 480px) {
        h4 {
            font-size: 16px !important;
            line-height: 150% !important
        }
    }

    @media only screen and (max-width: 480px) {
        .mcnBoxedTextContentContainer .mcnTextContent, .mcnBoxedTextContentContainer .mcnTextContent p {
            font-size: 14px !important;
            line-height: 150% !important
        }
    }

    @media only screen and (max-width: 480px) {
        #templatePreheader {
            display: block !important
        }
    }

    @media only screen and (max-width: 480px) {
        #templatePreheader .mcnTextContent, #templatePreheader .mcnTextContent p {
            font-size: 14px !important;
            line-height: 150% !important
        }
    }

    @media only screen and (max-width: 480px) {
        #templateHeader .mcnTextContent, #templateHeader .mcnTextContent p {
            font-size: 16px !important;
            line-height: 150% !important
        }
    }

    @media only screen and (max-width: 480px) {
        #templateBody .mcnTextContent, #templateBody .mcnTextContent p {
            font-size: 16px !important;
            line-height: 150% !important
        }
    }

    @media only screen and (max-width: 480px) {
        #templateFooter .mcnTextContent, #templateFooter .mcnTextContent p {
            font-size: 14px !important;
            line-height: 150% !important
        }
    }</style>
<center>
    <table id="bodyTable"
           style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;background-color:#FAFAFA;border-collapse:collapse;height:100%;margin:0;mso-table-lspace:0;mso-table-rspace:0;padding:0;width:100%"
           width="100%" height="100%" cellspacing="0" cellpadding="0" border="0" align="center">
        <tbody>
        <tr>
            <td id="bodyCell"
                style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-top:0;height:100%;margin:0;mso-line-height-rule:exactly;padding:10px;width:100%"
                valign="top" align="center"><!--[if (gte mso 9)|(IE)]>
                <table align="center" border="0" cellspacing="0" cellpadding="0" width="600" style="width:600px;">
                    <tr>
                        <td align="center" valign="top" width="600" style="width:600px;">
                <![endif]-->
                <table class="templateContainer"
                       style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border:0;border-collapse:collapse;max-width:600px!important;mso-table-lspace:0;mso-table-rspace:0"
                       width="100%" cellspacing="0" cellpadding="0" border="0">
                    <tbody>
                    <tr>
                        <td id="templatePreheader"
                            style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;background-color:#FAFAFA;background-image:none;background-position:center;background-repeat:no-repeat;background-size:cover;border-bottom:0;border-top:0;mso-line-height-rule:exactly;padding-bottom:9px;padding-top:9px"
                            valign="top">
                            <table class="mcnTextBlock"
                                   style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-collapse:collapse;min-width:100%;mso-table-lspace:0;mso-table-rspace:0"
                                   width="100%" cellspacing="0" cellpadding="0" border="0">
                                <tbody class="mcnTextBlockOuter">
                                <tr>
                                    <td class="mcnTextBlockInner"
                                        style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;mso-line-height-rule:exactly;padding-top:9px"
                                        valign="top"><!--[if mso]>
                                        <table align="left" border="0" cellspacing="0" cellpadding="0" width="100%"
                                               style="width:100%;">
                                            <tr>
                                        <![endif]--><!--[if mso]>
                                        <td valign="top" width="600" style="width:600px;">
                                        <![endif]-->
                                        <table style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-collapse:collapse;max-width:100%;min-width:100%;mso-table-lspace:0;mso-table-rspace:0"
                                               class="mcnTextContentContainer" width="100%" cellspacing="0"
                                               cellpadding="0" border="0" align="left">
                                            <tbody>
                                            <tr>
                                                <td class="mcnTextContent"
                                                    style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;color:#656565;font-family:Helvetica;font-size:12px;line-height:150%;mso-line-height-rule:exactly;padding:0 18px 9px;text-align:center;word-break:break-word"
                                                    valign="top">
													<?php echo $header; ?>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <!--[if mso]>
                                        </td>
                                        <![endif]--><!--[if mso]>
                                        </tr>
                                        </table>
                                        <![endif]--></td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td id="templateBody"
                            style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;background-color:#FFF;background-image:none;background-position:center;background-repeat:no-repeat;background-size:cover;border-bottom:2px solid #EAEAEA;border-top:0;mso-line-height-rule:exactly;padding-bottom:9px;padding-top:0"
                            valign="top">
                            <table class="mcnTextBlock"
                                   style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-collapse:collapse;min-width:100%;mso-table-lspace:0;mso-table-rspace:0"
                                   width="100%" cellspacing="0" cellpadding="0" border="0">
                                <tbody class="mcnTextBlockOuter">
                                <tr>
                                    <td class="mcnTextBlockInner"
                                        style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;mso-line-height-rule:exactly;padding-top:9px"
                                        valign="top"><!--[if mso]>
                                        <table align="left" border="0" cellspacing="0" cellpadding="0" width="100%"
                                               style="width:100%;">
                                            <tr>
                                        <![endif]--><!--[if mso]>
                                        <td valign="top" width="600" style="width:600px;">
                                        <![endif]-->
                                        <table style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-collapse:collapse;max-width:100%;min-width:100%;mso-table-lspace:0;mso-table-rspace:0"
                                               class="mcnTextContentContainer" width="100%" cellspacing="0"
                                               cellpadding="0" border="0" align="left">
                                            <tbody>
                                            <tr>
                                                <td class="mcnTextContent"
                                                    style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;color:#202020;font-family:Helvetica;font-size:16px;line-height:150%;mso-line-height-rule:exactly;padding-bottom:9px;padding-left:18px;padding-right:18px;padding-top:0;text-align:left;word-break:break-word"
                                                    valign="top">
                                                    <p><b><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_ID');?>:</b> <?php echo $item->id; ?></p>

													<?php if (isset($item->name)) : ?>
                                                        <p><b><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_NAME');?>:</b> <?php echo $item->name; ?></p>
													<?php endif; ?>

                                                    <?php if (isset($item->email)) : ?>
                                                        <p><b><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_EMAIL');?>:</b> <?php echo $item->email; ?></p>
													<?php endif; ?>

                                                    <p><b><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_OBJECT');?>:</b> <a href="<?php echo rtrim(Uri::root(), '/') . Route::_($item->object->link, false);?>"><?php echo $item->object->title; ?></a></p>

                                                    <p><b><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_RATING');?>:</b> <b><?php echo $item->rating; ?></b></p>

                                                    <p><b><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_TEXT');?>:</b> <?php echo StringHelper::truncate($item->text, 400, true, false); ?></p>
                                                    <hr>
                                                    <p><a href="<?php echo Uri::root(); ?>/administrator/index.php?option=com_radicalreviews&view=review&layout=edit&id=<?php echo $item->id; ?>"><?php echo Text::_('PLG_RADICALREVIEWS_EMAIL_EDIT');?></a></p>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <!--[if mso]>
                                        </td>
                                        <![endif]--><!--[if mso]>
                                        </tr>
                                        </table>
                                        <![endif]--></td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td id="templateFooter"
                            style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;background-color:#FAFAFA;background-image:none;background-position:center;background-repeat:no-repeat;background-size:cover;border-bottom:0;border-top:0;mso-line-height-rule:exactly;padding-bottom:9px;padding-top:9px"
                            valign="top">
                            <table class="mcnTextBlock"
                                   style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-collapse:collapse;min-width:100%;mso-table-lspace:0;mso-table-rspace:0"
                                   width="100%" cellspacing="0" cellpadding="0" border="0">
                                <tbody class="mcnTextBlockOuter">
                                <tr>
                                    <td class="mcnTextBlockInner"
                                        style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;mso-line-height-rule:exactly;padding-top:9px"
                                        valign="top"><!--[if mso]>
                                        <table align="left" border="0" cellspacing="0" cellpadding="0" width="100%"
                                               style="width:100%;">
                                            <tr>
                                        <![endif]--><!--[if mso]>
                                        <td valign="top" width="600" style="width:600px;">
                                        <![endif]-->
                                        <table style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;border-collapse:collapse;max-width:100%;min-width:100%;mso-table-lspace:0;mso-table-rspace:0"
                                               class="mcnTextContentContainer" width="100%" cellspacing="0"
                                               cellpadding="0" border="0" align="left">
                                            <tbody>
                                            <tr>
                                                <td class="mcnTextContent"
                                                    style="-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%;color:#656565;font-family:Helvetica;font-size:12px;line-height:150%;mso-line-height-rule:exactly;padding-bottom:9px;padding-left:18px;padding-right:18px;padding-top:0;text-align:left;word-break:break-word"
                                                    valign="top">
													<?php
													if ($footer)
													{
														foreach ($footer as $key => $value)
														{
                                                            if ($key === 'ip')
                                                            {
                                                                $value = '<a href="https://whois.domaintools.com/' . $value . '">' . $value . '</a>';
                                                            }

															echo '<p>' . Text::_('PLG_RADICALREVIEWS_EMAIL_' . strtoupper($key)) . ': <b>' . $value . '</b></p>';
														}
													}
													?>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                        <!--[if mso]>
                                        </td>
                                        <![endif]--><!--[if mso]>
                                        </tr>
                                        </table>
                                        <![endif]--></td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <!--[if (gte mso 9)|(IE)]>
                </td>
                </tr>
                </table>
                <![endif]--></td>
        </tr>
        </tbody>
    </table>
</center>
</body>
</html>