<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  RadicalMart.pdf
 *
 * @copyright   (C) 2025 www.codersite.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Codersite\Plugin\Content\RadicalmartFieldsPdf\Extension;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;

\defined('_JEXEC') or die;

/**
 * поле PDF для RadicalMart
 *
 * 1.0.0
 */
final class RadicalmartFieldsPdf extends CMSPlugin implements SubscriberInterface
{
    /**
     * Application object
     *
     * @var    CMSApplication
     * @since  1.0.0
     */
    protected $app;

    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  1.0.0
     */
    protected $autoloadLanguage = true;
//	use SiteRouterAwareTrait;
//	use DatabaseAwareTrait;
//	use UserFactoryAwareTrait;

	public function __construct(&$subject, $config = [])
	{
		parent::__construct($subject, $config);
	}
	public static function getSubscribedEvents(): array
	{
		return [
			'onContentPrepareForm' => 'onContentPrepareForm',
		];
	}
	public function onContentPrepareForm(Event $event): void
	{
        if (!$this->app->isClient('administrator')) {
            return;
        }
		$form = $event->getArgument('form');
		if ($form->getName() !== 'com_radicalmart.product')
		{
			return;
		}
        //Log::add(print_r($form->getName(), true), Log::INFO, 'log');
		$this->addPdfField($form);
	}
	private function addPdfField($form) : void
	{
		$customField = '
		<form>
            <fields name="params">
                <fieldset name="basic" label="PLG_CONTENT_RADICALMARTFIELDSPDF_LABEL">
                    <field
                      label="PLG_CONTENT_RADICALMARTFIELDSPDF_LABEL" 
                      name="pdf"
                      layout="joomla.form.field.pdf"
                      type="accessiblemedia"
                      accept=".pdf"
                    />
                </fieldset>
            </fields>
        </form>
	';
		$form->load($customField);
	}
}
