<?php

namespace MSGJoomla\Plugin\Finder\RadicalMart\Adapter;

use Joomla\CMS\HTML\Registry;
use Joomla\Database\DatabaseInterface;

\defined('JPATH_PLATFORM') or die;

class AdapterFactory
{
    /**
     * Method to create a Driver instance.
     *
     * @param string $type
     * @param \Joomla\Registry\Registry $params
     * @param DatabaseInterface $db
     *
     * @return  Adapter|bool
     *
     * @since   0.0.1
     */
    public static function getAdapter(string $type, \Joomla\Registry\Registry $params, DatabaseInterface $db)
    {
        // Check default class for field
        $class_name = __NAMESPACE__ . '\\' . ucfirst($type);

        if (!class_exists($class_name))
        {
            return false;
        }

        $adapter = new $class_name($params, $db);

        return $adapter;
    }
}
