<?php
/**
 * @copyright   (c) 2013-2024 Nekrasov Vitaliy <nekrasov_vitaliy@list.ru>
 * @license     GNU General Public License version 2 or later
 */
namespace Joomla\Plugin\Jshoppingadmin\Wishboxmuimages\Extension;

use Exception;
use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Component\Jshopping\Site\Lib\JSFactory;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use function defined;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * @since 1.0.0
 */
class Wishboxmuimages extends CMSPlugin implements SubscriberInterface
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 *
	 * @since  1.0.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since 1.0.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onBeforeDisplayEditProductView'    => 'onBeforeDisplayEditProductView',
			'onAfterSaveProduct'                => 'onAfterSaveProduct',
		];
	}

	/**
	 * @param   Event  $e  Event
	 *
	 * @return void
	 *
	 * @throws Exception
	 *
	 * @since  1.0.0
	 *
	 * @noinspection PhpUnused
	 * @noinspection PhpUnusedParameterInspection
	 */
	public function onBeforeDisplayEditProductView(Event $e): void
	{
		/** @var CMSWebApplicationInterface $app */
		$app = Factory::getApplication();

		$wa = $app->getDocument()->getWebAssetManager();
		$jshopConfig = JSFactory::getConfig();

		$wa->addInlineScript(
			'var wishboxmuimages_product_image_upload_count = ' . $jshopConfig->product_image_upload_count . ';'
		);
		HTMLHelper::script('plg_jshoppingadmin_wishboxmuimages/script.js', ['framework' => true, 'relative' => true]);
	}


	/**
	 * @param   Event  $e  Event
	 *
	 * @return void
	 *
	 * @since 1.0.0
	 *
	 * @noinspection PhpUnused
	 * @noinspection PhpUnusedParameterInspection
	 */
	public function onAfterSaveProduct(Event $e): void
	{
		$count = count($_FILES['wishbox_product_images']['name']);

		for ($i = 0; $i < $count; $i++)
		{
			$_FILES['product_image_'.$i] = [
				'name'      => $_FILES['wishbox_product_images']['name'][$i],
				'type'      => $_FILES['wishbox_product_images']['type'][$i],
				'tmp_name'  => $_FILES['wishbox_product_images']['tmp_name'][$i],
				'error'     => $_FILES['wishbox_product_images']['error'][$i],
				'size'      => $_FILES['wishbox_product_images']['size'][$i]
			];
		}

		unset($_FILES['wishbox_product_images']);
	}
}
