<?php
/*
 * @package     RadicalMart Package
 * @subpackage  pkg_radicalmart_fiscalization
 * @version     1.0.1
 * @author      RadicalMart Team - radicalmart.ru
 * @copyright   Copyright (c) 2024 RadicalMart. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://radicalmart.ru/
 */

namespace Joomla\Plugin\RadicalMart\Fiscalization\Helper;

\defined('_JEXEC') or die;

class PriceHelper
{
	/**
	 * Method to convert price from float to integer.
	 *
	 * @param   float|null  $price     Price value.
	 * @param   array       $currency  Currency data.
	 *
	 * @return int Integer price value.
	 *
	 * @since 1.0.0
	 */
	public static function toInteger(?float $price, array $currency): int
	{
		if (empty($price))
		{
			return 0;
		}

		$decimals = (int) $currency['decimals'];
		if (empty($decimals))
		{
			return (int) $price;
		}

		return round($price * pow(10, $decimals));
	}

	/**
	 * Method to convert price from integer to float.
	 *
	 * @param   int|null  $price     Price value.
	 * @param   array     $currency  Currency data.
	 *
	 * @return float Float price value.
	 *
	 * @since 1.0.0
	 */
	public static function toFloat(?int $price, array $currency): float
	{
		if (empty($price))
		{
			return 0.0;
		}

		$price    = (float) $price;
		$decimals = (int) $currency['decimals'];
		if (empty($decimals))
		{
			return $price;
		}

		$price = ($price / pow(10, $decimals));

		return (float) number_format($price, $decimals, '.', '');
	}
}