<?php
/*
 * @package   plg_system_accesspro
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

use Joomla\Plugin\System\AccessPro\Helper\AccessHelper;
use YOOtheme\Builder;

return [

	// Add builder elements
	'extend' => [

		Builder::class => function (Builder $builder) {
			$builder->addTransform('prerender', new AccessHelper());
		}

	],
	'events' => [

		'builder.type' => [
			AccessHelper::class => ['initSource', 50],
		],
		'customizer.init' => [
			AccessHelper::class => ['initCustomizer', -10],
		]
	]
];
