<?php
/*
 * @package   plg_system_accesspro
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Plugin\System\AccessPro\Helper;

use Joomla\CMS\Language\Text;
use YOOtheme\Config;
use YOOtheme\Path;
use YOOtheme\Translator;

class AccessHelper
{
	/**
	 * Method for init Yootheme Pro customizer
	 *
	 * @param   Config      $config
	 * @param   Translator  $translator
	 *
	 * @since 1.0.0
	 */
	public static function initCustomizer(Config $config, Translator $translator)
	{
		$locale = str_replace('_', '-', $config('locale.code'));

		$translator->addResource(Path::get('../../../../../administrator/language/' . $locale . '/plg_system_accesspro.json'));
		$translator->addResource(Path::get('../../../../../administrator/language/' . $locale . '/plg_system_accesspro_custom.json'));
	}

	/**
	 * Transform callback.
	 *
	 * Use for frontend elements manipulate
	 *
	 * @param   object  $node
	 * @param   array   $params
	 *
	 * @since 1.0.0
	 */
	public function __invoke($node, array $params)
	{
		$rules = RuleHelper::getRules();
		$props = $node->props;

		foreach ($rules as $rule)
		{
			$ruleClass = RuleHelper::getRule($rule);
			$ruleType  = $ruleClass->type;

			if (isset($props[$ruleType]) && !empty($props[$ruleType]))
			{
				return $ruleClass->canAccess($props);
			}
		}
	}

	/**
	 * Method for add extra tab to each element.
	 *
	 * @param   object  $node
	 * @param   array   $params
	 *
	 * @since 1.0.0
	 */
	public static function initSource(array $type)
	{
		if (isset($type) && isset($type['fieldset']) && isset($type['fieldset']['default']))
		{

			// Add new fieldset settings tab
			$newFieldset = [
				'title'  => Text::_('PLG_SYSTEM_ACCESSPRO_FIELDSET_TITLE'),
				'fields' => []
			];

			$fields = [];
			$rules  = RuleHelper::getRules();

			foreach ($rules as $rule)
			{
				$ruleClass         = RuleHelper::getRule($rule);
				$ruleType          = $ruleClass->type;
				$fields[$ruleType] = $ruleClass->getFields();
			}

			$newFieldset['fields'] = $fields;
			$advancedFieldset      = array_pop($type['fieldset']['default']['fields']);

			$type['fieldset']['default']['fields'][] = $newFieldset;
			$type['fieldset']['default']['fields'][] = $advancedFieldset;
		}

		return $type;
	}
}