<?php
/*
 * @package   plg_system_accesspro
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Plugin\System\AccessPro\Rule\Collection;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\Plugin\System\AccessPro\Rule\AbstractRule;

class LanguageRule extends AbstractRule
{
	/**
	 * Type of rule
	 *
	 * @var string
	 *
	 * @since 1.0.0
	 */
	public $type = 'language';

	/**
	 * Available languages
	 *
	 * @var string
	 *
	 * @since 1.0.0
	 */
	static public $availableLanguages = [];

	/**
	 * Method for check access for element
	 *
	 * @var array $props Properties of elements
	 *
	 * @since 1.0.0
	 */
	public function canAccess($props): bool
	{
		$languages      = $props[$this->type];
		$activeLanguage = str_replace('_', '-', Factory::getApplication()->getLanguage()->get('tag'));

		return in_array($activeLanguage, (array) $languages);
	}

	/**
	 * Method for get fields for dynamic adding to config
	 *
	 * @var array $props Properties of elements
	 *
	 * @since 1.0.0
	 */
	public function getFields(): array
	{
		return [
			'label'       => $this->type . '_label',
			'type'        => 'select',
			'source'      => true,
			'description' => $this->type . '_description',
			'attrs'       => [
				'multiple' => true,
				'class'    => 'uk-height-small uk-resize-vertical'
			],
			'options'     => $this->getAvailableLanguages()
		];
	}

	/**
	 * Method for get available languages
	 *
	 * @since 1.0.0
	 */
	protected function getAvailableLanguages(): array
	{
		if (empty(self::$availableLanguages))
		{
			self::$availableLanguages = array_flip(array_map(function ($language) {
				return $language['name'];
			}, LanguageHelper::getKnownLanguages(JPATH_SITE)));
		}

		return self::$availableLanguages;
	}
}
