<?php
/*
 * @package   plg_system_accesspro
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Plugin\System\AccessPro\Helper;

use Exception;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\CMS\Http\Http;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
use Joomla\Plugin\System\AccessPro\Rule\AbstractRule;
use Joomla\Registry\Registry;

class RuleHelper
{
	/**
	 * A list of paths
	 *
	 * @var array
	 * @since 1.0.0
	 */
	const PATH_RULES = JPATH_PLUGINS . '/system/accesspro/src/Rule/Collection';

	/**
	 * Get all collected types
	 *
	 * @param $type  - schema, meta, extra
	 *
	 * @return array
	 *
	 * @since 1.0.0
	 */
	public static function getRules()
	{
		$result = [];
		$path   = self::PATH_RULES;

		if ($path && Folder::exists($path))
		{
			$files = Folder::files($path, '.php');

			if ($files)
			{
				foreach ($files as $file)
				{
					$result[] = str_replace('Rule', '', lcfirst(File::stripExt($file)));
				}
			}
		}

		return $result;
	}

	/**
	 * Method to create a Rule instance.
	 *
	 * @param   string                     $rule
	 *
	 * @return  AbstractRule|bool
	 *
	 * @since   1.0.0
	 */
	public static function getRule($rule)
	{
		if (!$rule)
		{
			return false;
		}

		// Check default class for field
		$class_name = '\\Joomla\\Plugin\\System\\AccessPro\\Rule\\Collection\\' . ucfirst($rule) . 'Rule';

		if (!class_exists($class_name))
		{
			return false;
		}

		$rule = new $class_name();

		return $rule;
	}
}