<?php
/*
 * @package   plg_system_accesspro
 * @version   1.0.0
 * @author    Dmitriy Vasyukov - https://fictionlabs.ru
 * @copyright Copyright (c) 2023 Fictionlabs. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link      https://fictionlabs.ru/
 */

namespace Joomla\Plugin\System\AccessPro\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use YOOtheme\Application;

class AccessPro extends CMSPlugin implements SubscriberInterface
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    bool
	 *
	 * @since  1.0.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since   1.0.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onAfterInitialise'    => 'onAfterInitialise'
		];
	}

	/**
	 * OnAfterInitialise event
	 *
	 * @since  1.0.0
	 */
	public function onAfterInitialise()
	{
		// Check if YOOtheme Pro is loaded
		if (class_exists(Application::class, false))
		{
			// Load a single module from the same directory
			$app = Application::getInstance();
			$app->load(JPATH_PLUGINS . '/' . $this->_type . '/' . $this->_name . '/bootstrap.php');
		}
	}
}